/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.validate;

import com.hazelcast.jet.sql.impl.connector.SqlConnector;
import com.hazelcast.jet.sql.impl.connector.SqlConnectorUtil;
import com.hazelcast.jet.sql.impl.parse.SqlCreateJob;
import com.hazelcast.jet.sql.impl.parse.SqlShowStatement;
import com.hazelcast.jet.sql.impl.schema.JetSqlUserDefinedTableFunction;
import com.hazelcast.jet.sql.impl.validate.JetSqlOperatorTable;
import com.hazelcast.jet.sql.impl.validate.ValidatorResource;
import com.hazelcast.sql.impl.calcite.schema.HazelcastTable;
import com.hazelcast.sql.impl.calcite.validate.HazelcastSqlValidator;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastTypeFactory;
import java.util.Collection;
import java.util.List;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlInsert;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.util.SqlBasicVisitor;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorCatalogReader;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.sql.validate.SqlValidatorTable;

public class JetSqlValidator
extends HazelcastSqlValidator {
    private boolean isCreateJob;

    public JetSqlValidator(SqlValidatorCatalogReader catalogReader, HazelcastTypeFactory typeFactory, SqlConformance conformance) {
        super((SqlOperatorTable)JetSqlOperatorTable.instance(), catalogReader, typeFactory, conformance);
    }

    public SqlNode validate(SqlNode topNode) {
        if (topNode instanceof SqlCreateJob) {
            this.isCreateJob = true;
        }
        if (topNode.getKind().belongsTo((Collection)SqlKind.DDL)) {
            topNode.validate((SqlValidator)this, this.getEmptyScope());
            return topNode;
        }
        if (topNode instanceof SqlShowStatement) {
            return topNode;
        }
        return super.validate(topNode);
    }

    public void validateInsert(SqlInsert insert) {
        super.validateInsert(insert);
        if (!this.isCreateJob && this.containsStreamingSource(insert.getSource())) {
            throw this.newValidationError((SqlNode)insert, ValidatorResource.RESOURCE.mustUseCreateJob());
        }
    }

    protected void validateGroupClause(SqlSelect select) {
        super.validateGroupClause(select);
        if (this.containsGroupingOrAggregation(select) && this.containsStreamingSource((SqlNode)select)) {
            throw this.newValidationError((SqlNode)select, ValidatorResource.RESOURCE.streamingAggregationsNotSupported());
        }
    }

    private boolean containsGroupingOrAggregation(SqlSelect select) {
        if (select.getGroup() != null && select.getGroup().size() > 0) {
            return true;
        }
        if (select.isDistinct()) {
            return true;
        }
        for (SqlNode node : select.getSelectList()) {
            if (!node.getKind().belongsTo((Collection)SqlKind.AGGREGATE)) continue;
            return true;
        }
        return false;
    }

    private boolean containsStreamingSource(SqlNode node) {
        class FindStreamingTablesVisitor
        extends SqlBasicVisitor<Void> {
            boolean found;

            FindStreamingTablesVisitor() {
            }

            public Void visit(SqlIdentifier id) {
                HazelcastTable hazelcastTable;
                SqlConnector connector;
                SqlValidatorTable table = JetSqlValidator.this.getCatalogReader().getTable((List)id.names);
                if (table != null && (connector = SqlConnectorUtil.getJetSqlConnector((hazelcastTable = (HazelcastTable)table.unwrap(HazelcastTable.class)).getTarget())).isStream()) {
                    this.found = true;
                    return null;
                }
                return (Void)super.visit(id);
            }

            public Void visit(SqlCall call) {
                SqlOperator operator = call.getOperator();
                if (operator instanceof JetSqlUserDefinedTableFunction && ((JetSqlUserDefinedTableFunction)operator).isStreaming()) {
                    this.found = true;
                    return null;
                }
                return (Void)super.visit(call);
            }
        }
        FindStreamingTablesVisitor visitor = new FindStreamingTablesVisitor();
        node.accept((SqlVisitor)visitor);
        return visitor.found;
    }

    protected void validateJoin(final SqlJoin join, SqlValidatorScope scope) {
        super.validateJoin(join, scope);
        join.getRight().accept((SqlVisitor)new SqlBasicVisitor<Void>(){

            public Void visit(SqlCall call) {
                if (call.getKind() == SqlKind.SELECT) {
                    throw JetSqlValidator.this.newValidationError((SqlNode)join, ValidatorResource.RESOURCE.joiningSubqueryNotSupported());
                }
                if (call.getKind() == SqlKind.VALUES) {
                    throw JetSqlValidator.this.newValidationError((SqlNode)join, ValidatorResource.RESOURCE.joiningValuesNotSupported());
                }
                return (Void)call.getOperator().acceptCall((SqlVisitor)this, call);
            }
        });
    }
}

