/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.validate;

import com.hazelcast.jet.sql.impl.connector.file.FileTableFunction;
import com.hazelcast.jet.sql.impl.connector.generator.SeriesGeneratorTableFunction;
import com.hazelcast.jet.sql.impl.connector.generator.StreamGeneratorTableFunction;
import com.hazelcast.jet.sql.impl.schema.JetSqlUserDefinedTableFunction;
import com.hazelcast.jet.sql.impl.schema.JetTableFunction;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastTypeFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.FunctionParameter;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.FamilyOperandTypeChecker;
import org.apache.calcite.sql.type.InferTypes;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.util.ReflectiveSqlOperatorTable;
import org.apache.calcite.sql.validate.SqlNameMatcher;
import org.apache.calcite.sql.validate.SqlNameMatchers;
import org.apache.calcite.sql.validate.SqlUserDefinedTableFunction;
import org.apache.calcite.util.Util;

public final class JetSqlOperatorTable
extends ReflectiveSqlOperatorTable {
    public static final SqlFunction CSV_FILE = JetSqlOperatorTable.from(FileTableFunction.CSV, "CSV_FILE");
    public static final SqlFunction JSON_FILE = JetSqlOperatorTable.from(FileTableFunction.JSON, "JSON_FILE");
    public static final SqlFunction AVRO_FILE = JetSqlOperatorTable.from(FileTableFunction.AVRO, "AVRO_FILE");
    public static final SqlFunction PARQUET_FILE = JetSqlOperatorTable.from(FileTableFunction.PARQUET, "PARQUET_FILE");
    public static final SqlFunction GENERATE_SERIES = JetSqlOperatorTable.from(SeriesGeneratorTableFunction.GENERATE_SERIES, "GENERATE_SERIES");
    public static final SqlFunction GENERATE_STREAM = JetSqlOperatorTable.from(StreamGeneratorTableFunction.GENERATE_STREAM, "GENERATE_STREAM");
    private static final JetSqlOperatorTable INSTANCE = new JetSqlOperatorTable();

    private JetSqlOperatorTable() {
    }

    static JetSqlOperatorTable instance() {
        return INSTANCE;
    }

    static SqlUserDefinedTableFunction from(JetTableFunction function, String name) {
        HazelcastTypeFactory typeFactory = HazelcastTypeFactory.INSTANCE;
        ArrayList<RelDataType> types = new ArrayList<RelDataType>();
        ArrayList<Object> families = new ArrayList<Object>();
        for (FunctionParameter parameter : function.getParameters()) {
            RelDataType type = parameter.getType((RelDataTypeFactory)typeFactory);
            SqlTypeName typeName = type.getSqlTypeName();
            SqlTypeFamily typeFamily = typeName.getFamily();
            types.add(type);
            families.add(Util.first((Object)typeFamily, (Object)SqlTypeFamily.ANY));
        }
        FamilyOperandTypeChecker typeChecker = OperandTypes.family(families, index -> ((FunctionParameter)function.getParameters().get((int)index)).isOptional());
        return new JetSqlUserDefinedTableFunction(new SqlIdentifier(name, SqlParserPos.ZERO), ReturnTypes.CURSOR, InferTypes.explicit(types), (SqlOperandTypeChecker)typeChecker, types, function);
    }

    public void lookupOperatorOverloads(SqlIdentifier name, SqlFunctionCategory category, SqlSyntax syntax, List<SqlOperator> operators, SqlNameMatcher nameMatcher) {
        super.lookupOperatorOverloads(name, category, syntax, operators, SqlNameMatchers.withCaseSensitive((boolean)false));
    }

    static {
        INSTANCE.init();
    }
}

