/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.schema;

import com.hazelcast.jet.sql.impl.connector.SqlConnector;
import com.hazelcast.sql.impl.calcite.schema.HazelcastTable;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeComparability;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeFamily;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypePrecedenceList;
import org.apache.calcite.rel.type.StructKind;
import org.apache.calcite.schema.TableFunction;
import org.apache.calcite.sql.SqlCollation;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.type.SqlTypeName;

public abstract class JetTableFunction
implements TableFunction {
    private final SqlConnector connector;

    protected JetTableFunction(SqlConnector connector) {
        this.connector = connector;
    }

    public final boolean isStream() {
        return this.connector.isStream();
    }

    public final HazelcastTable toTable(RelDataType rowType) {
        return ((JetFunctionRelDataType)rowType).table();
    }

    public final Type getElementType(List<Object> arguments) {
        return Object[].class;
    }

    public RelDataType getRowType(RelDataTypeFactory typeFactory, List<Object> arguments) {
        HazelcastTable table = this.toTable(arguments);
        RelDataType rowType = table.getRowType(typeFactory);
        return new JetFunctionRelDataType(table, rowType);
    }

    protected abstract HazelcastTable toTable(List<Object> var1);

    private static final class JetFunctionRelDataType
    implements RelDataType {
        private final HazelcastTable table;
        private final RelDataType delegate;

        private JetFunctionRelDataType(HazelcastTable table, RelDataType delegate) {
            this.delegate = delegate;
            this.table = table;
        }

        private HazelcastTable table() {
            return this.table;
        }

        public boolean isStruct() {
            return this.delegate.isStruct();
        }

        public List<RelDataTypeField> getFieldList() {
            return this.delegate.getFieldList();
        }

        public List<String> getFieldNames() {
            return this.delegate.getFieldNames();
        }

        public int getFieldCount() {
            return this.delegate.getFieldCount();
        }

        public StructKind getStructKind() {
            return this.delegate.getStructKind();
        }

        public RelDataTypeField getField(String fieldName, boolean caseSensitive, boolean elideRecord) {
            return this.delegate.getField(fieldName, caseSensitive, elideRecord);
        }

        public boolean isNullable() {
            return this.delegate.isNullable();
        }

        public RelDataType getComponentType() {
            return this.delegate.getComponentType();
        }

        public RelDataType getKeyType() {
            return this.delegate.getKeyType();
        }

        public RelDataType getValueType() {
            return this.delegate.getValueType();
        }

        public Charset getCharset() {
            return this.delegate.getCharset();
        }

        public SqlCollation getCollation() {
            return this.delegate.getCollation();
        }

        public SqlIntervalQualifier getIntervalQualifier() {
            return this.delegate.getIntervalQualifier();
        }

        public int getPrecision() {
            return this.delegate.getPrecision();
        }

        public int getScale() {
            return this.delegate.getScale();
        }

        public SqlTypeName getSqlTypeName() {
            return this.delegate.getSqlTypeName();
        }

        public SqlIdentifier getSqlIdentifier() {
            return this.delegate.getSqlIdentifier();
        }

        public String toString() {
            return this.delegate.toString();
        }

        public String getFullTypeString() {
            return this.delegate.getFullTypeString();
        }

        public RelDataTypeFamily getFamily() {
            return this.delegate.getFamily();
        }

        public RelDataTypePrecedenceList getPrecedenceList() {
            return this.delegate.getPrecedenceList();
        }

        public RelDataTypeComparability getComparability() {
            return this.delegate.getComparability();
        }

        public boolean isDynamicStruct() {
            return this.delegate.isDynamicStruct();
        }
    }
}

