/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.logical;

import com.google.common.collect.ImmutableList;
import com.hazelcast.jet.sql.impl.opt.OptUtils;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.core.Union;
import org.apache.calcite.rel.logical.LogicalUnion;
import org.apache.calcite.rel.logical.LogicalValues;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexLiteral;

final class ValuesUnionLogicalRule
extends RelOptRule {
    static final RelOptRule INSTANCE;
    private static final RelOptRuleOperand CHILD_OPERAND;

    private ValuesUnionLogicalRule() {
        super(ValuesUnionLogicalRule.operand(LogicalUnion.class, (RelOptRuleOperandChildren)ValuesUnionLogicalRule.unordered((RelOptRuleOperand)CHILD_OPERAND, (RelOptRuleOperand[])new RelOptRuleOperand[0])), RelFactories.LOGICAL_BUILDER, ValuesUnionLogicalRule.class.getSimpleName());
    }

    public void onMatch(RelOptRuleCall call) {
        Union union = (Union)call.rel(0);
        ImmutableList<ImmutableList<RexLiteral>> tuples = ValuesUnionLogicalRule.extractTuples(union);
        LogicalValues rel = LogicalValues.create((RelOptCluster)union.getCluster(), (RelDataType)union.getRowType(), tuples);
        call.transformTo((RelNode)rel);
    }

    private static ImmutableList<ImmutableList<RexLiteral>> extractTuples(Union union) {
        return union.getInputs().stream().map(input -> (LogicalValues)OptUtils.findMatchingRel(input, CHILD_OPERAND)).flatMap(values -> values.getTuples().stream()).collect(Collectors.collectingAndThen(Collectors.toList(), ImmutableList::copyOf));
    }

    static {
        CHILD_OPERAND = ValuesUnionLogicalRule.operand(LogicalValues.class, (RelOptRuleOperandChildren)ValuesUnionLogicalRule.none());
        INSTANCE = new ValuesUnionLogicalRule();
    }
}

