/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.extract;

import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.jet.json.JsonUtil;
import com.hazelcast.sql.impl.extract.QueryExtractor;
import com.hazelcast.sql.impl.extract.QueryTarget;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.io.IOException;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class JsonQueryTarget
implements QueryTarget {
    private Map<String, Object> json;

    public void setTarget(Object target) {
        try {
            this.json = target instanceof Map ? (Map)target : JsonUtil.mapFrom((Object)target);
        }
        catch (IOException e) {
            throw ExceptionUtil.sneakyThrow((Throwable)e);
        }
    }

    public QueryExtractor createExtractor(String path, QueryDataType type) {
        return path == null ? this.createExtractor() : this.createFieldExtractor(path, type);
    }

    private QueryExtractor createExtractor() {
        return () -> this.json;
    }

    private QueryExtractor createFieldExtractor(String path, QueryDataType type) {
        return () -> type.convert(this.json.get(path));
    }
}

