/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.map;

import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadata;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadataResolver;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadataResolvers;
import com.hazelcast.jet.sql.impl.inject.PortableUpsertTargetDescriptor;
import com.hazelcast.jet.sql.impl.schema.MappingField;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.FieldDefinition;
import com.hazelcast.nio.serialization.FieldType;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.extract.GenericQueryTargetDescriptor;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.extract.QueryTargetDescriptor;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.schema.map.MapTableField;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class MetadataPortableResolver
implements KvMetadataResolver {
    static final MetadataPortableResolver INSTANCE = new MetadataPortableResolver();

    private MetadataPortableResolver() {
    }

    @Override
    public String supportedFormat() {
        return "portable";
    }

    @Override
    public List<MappingField> resolveAndValidateFields(boolean isKey, List<MappingField> userFields, Map<String, String> options, InternalSerializationService serializationService) {
        ClassDefinition classDefinition = this.resolveClassDefinition(isKey, options, serializationService);
        return this.resolveFields(isKey, userFields, classDefinition);
    }

    List<MappingField> resolveFields(boolean isKey, List<MappingField> userFields, ClassDefinition clazz) {
        Set<Map.Entry<String, FieldType>> fieldsInClass = MetadataPortableResolver.resolvePortable(clazz).entrySet();
        Map<QueryPath, MappingField> userFieldsByPath = KvMetadataResolvers.extractFields(userFields, isKey);
        if (!userFields.isEmpty()) {
            for (Map.Entry<String, FieldType> classField : fieldsInClass) {
                QueryPath path = new QueryPath(classField.getKey(), isKey);
                QueryDataType type = MetadataPortableResolver.resolvePortableType(classField.getValue());
                MappingField mappingField = userFieldsByPath.get(path);
                if (mappingField == null || type.getTypeFamily().equals((Object)mappingField.type().getTypeFamily())) continue;
                throw QueryException.error((String)("Mismatch between declared and resolved type: " + mappingField.name()));
            }
            return new ArrayList<MappingField>(userFieldsByPath.values());
        }
        ArrayList<MappingField> fields = new ArrayList<MappingField>();
        for (Map.Entry<String, FieldType> classField : fieldsInClass) {
            QueryPath path = new QueryPath(classField.getKey(), isKey);
            QueryDataType type = MetadataPortableResolver.resolvePortableType(classField.getValue());
            String name = classField.getKey();
            fields.add(new MappingField(name, type, path.toString()));
        }
        return fields;
    }

    private static Map<String, FieldType> resolvePortable(ClassDefinition classDefinition) {
        LinkedHashMap<String, FieldType> fields = new LinkedHashMap<String, FieldType>();
        for (int i = 0; i < classDefinition.getFieldCount(); ++i) {
            FieldDefinition fieldDefinition = classDefinition.getField(i);
            fields.putIfAbsent(fieldDefinition.getName(), fieldDefinition.getType());
        }
        return fields;
    }

    private static QueryDataType resolvePortableType(FieldType type) {
        switch (type) {
            case BOOLEAN: {
                return QueryDataType.BOOLEAN;
            }
            case BYTE: {
                return QueryDataType.TINYINT;
            }
            case SHORT: {
                return QueryDataType.SMALLINT;
            }
            case CHAR: {
                return QueryDataType.VARCHAR_CHARACTER;
            }
            case UTF: {
                return QueryDataType.VARCHAR;
            }
            case INT: {
                return QueryDataType.INT;
            }
            case LONG: {
                return QueryDataType.BIGINT;
            }
            case FLOAT: {
                return QueryDataType.REAL;
            }
            case DOUBLE: {
                return QueryDataType.DOUBLE;
            }
        }
        return QueryDataType.OBJECT;
    }

    @Override
    public KvMetadata resolveMetadata(boolean isKey, List<MappingField> resolvedFields, Map<String, String> options, InternalSerializationService serializationService) {
        ClassDefinition clazz = this.resolveClassDefinition(isKey, options, serializationService);
        return this.resolveMetadata(isKey, resolvedFields, clazz);
    }

    KvMetadata resolveMetadata(boolean isKey, List<MappingField> resolvedFields, ClassDefinition clazz) {
        Map<QueryPath, MappingField> externalFieldsByPath = KvMetadataResolvers.extractFields(resolvedFields, isKey);
        ArrayList<TableField> fields = new ArrayList<TableField>();
        for (Map.Entry<QueryPath, MappingField> entry : externalFieldsByPath.entrySet()) {
            QueryPath path = entry.getKey();
            QueryDataType type = entry.getValue().type();
            String name = entry.getValue().name();
            fields.add((TableField)new MapTableField(name, type, false, path));
        }
        KvMetadataResolvers.maybeAddDefaultField(isKey, resolvedFields, fields);
        return new KvMetadata(fields, (QueryTargetDescriptor)GenericQueryTargetDescriptor.DEFAULT, new PortableUpsertTargetDescriptor(clazz.getFactoryId(), clazz.getClassId(), clazz.getVersion()));
    }

    private ClassDefinition resolveClassDefinition(boolean isKey, Map<String, String> options, InternalSerializationService serializationService) {
        String factoryIdProperty = isKey ? "keyPortableFactoryId" : "valuePortableFactoryId";
        String factoryId = options.get(factoryIdProperty);
        String classIdProperty = isKey ? "keyPortableClassId" : "valuePortableClassId";
        String classId = options.get(classIdProperty);
        String classVersionProperty = isKey ? "keyPortableClassVersion" : "valuePortableClassVersion";
        String classVersion = options.getOrDefault(classVersionProperty, "0");
        if (factoryId == null || classId == null || classVersion == null) {
            throw QueryException.error((String)("Unable to resolve table metadata. Missing ['" + factoryIdProperty + "'|'" + classIdProperty + "'|'" + classVersionProperty + "'] option(s)"));
        }
        ClassDefinition classDefinition = serializationService.getPortableContext().lookupClassDefinition(Integer.parseInt(factoryId), Integer.parseInt(classId), Integer.parseInt(classVersion));
        if (classDefinition == null) {
            throw QueryException.error((String)("Unable to find class definition for factoryId: " + factoryId + ", classId: " + classId + ", classVersion: " + classVersion));
        }
        return classDefinition;
    }
}

