/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.map;

import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.jet.Traversers;
import com.hazelcast.jet.Util;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.impl.execution.init.Contexts;
import com.hazelcast.jet.impl.processor.AsyncTransformUsingServiceOrderedP;
import com.hazelcast.jet.pipeline.ServiceFactories;
import com.hazelcast.jet.sql.impl.ExpressionUtil;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvRowProjector;
import com.hazelcast.map.IMap;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.query.impl.getters.Extractors;
import com.hazelcast.sql.impl.expression.Expression;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

@SuppressFBWarnings(value={"SE_BAD_FIELD", "SE_NO_SERIALVERSIONID"}, justification="the class is never java-serialized")
final class JoinByPrimitiveKeyProcessorSupplier
implements ProcessorSupplier,
DataSerializable {
    private static final int MAX_CONCURRENT_OPS = 8;
    private boolean inner;
    private int leftEquiJoinIndex;
    private Expression<Boolean> condition;
    private String mapName;
    private KvRowProjector.Supplier rightRowProjectorSupplier;
    private transient IMap<Object, Object> map;
    private transient InternalSerializationService serializationService;
    private transient Extractors extractors;

    private JoinByPrimitiveKeyProcessorSupplier() {
    }

    JoinByPrimitiveKeyProcessorSupplier(boolean inner, int leftEquiJoinIndex, Expression<Boolean> condition, String mapName, KvRowProjector.Supplier rightRowProjectorSupplier) {
        this.inner = inner;
        this.leftEquiJoinIndex = leftEquiJoinIndex;
        this.condition = condition;
        this.mapName = mapName;
        this.rightRowProjectorSupplier = rightRowProjectorSupplier;
    }

    public void init(@Nonnull ProcessorSupplier.Context context) {
        this.map = context.jetInstance().getMap(this.mapName);
        this.serializationService = ((Contexts.ProcSupplierCtx)context).serializationService();
        this.extractors = Extractors.newBuilder((InternalSerializationService)this.serializationService).build();
    }

    @Nonnull
    public Collection<? extends Processor> get(int count) {
        ArrayList<AsyncTransformUsingServiceOrderedP> processors = new ArrayList<AsyncTransformUsingServiceOrderedP>(count);
        for (int i = 0; i < count; ++i) {
            KvRowProjector projector = this.rightRowProjectorSupplier.get(this.serializationService, this.extractors);
            TransientReference context = new TransientReference(this.map);
            AsyncTransformUsingServiceOrderedP processor = new AsyncTransformUsingServiceOrderedP(ServiceFactories.nonSharedService((FunctionEx & Serializable)ctx -> context), null, 8, (BiFunctionEx & Serializable)(ctx, left) -> {
                Object key = left[this.leftEquiJoinIndex];
                if (key == null) {
                    return this.inner ? null : CompletableFuture.completedFuture(null);
                }
                return ((IMap)((TransientReference)ctx).ref).getAsync(key).toCompletableFuture();
            }, (BiFunctionEx & Serializable)(left, value) -> {
                Object[] joined = JoinByPrimitiveKeyProcessorSupplier.join(left, left[this.leftEquiJoinIndex], value, projector, this.condition);
                return joined != null ? Traversers.singleton((Object)joined) : (this.inner ? null : Traversers.singleton((Object)com.hazelcast.jet.impl.util.Util.extendArray((Object[])left, (int)projector.getColumnCount())));
            });
            processors.add(processor);
        }
        return processors;
    }

    private static Object[] join(Object[] left, Object key, Object value, KvRowProjector rightRowProjector, Expression<Boolean> condition) {
        if (value == null) {
            return null;
        }
        Object[] right = rightRowProjector.project(Util.entry((Object)key, (Object)value));
        if (right == null) {
            return null;
        }
        return ExpressionUtil.join(left, right, condition);
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeBoolean(this.inner);
        out.writeInt(this.leftEquiJoinIndex);
        out.writeObject(this.condition);
        out.writeObject((Object)this.mapName);
        out.writeObject((Object)this.rightRowProjectorSupplier);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.inner = in.readBoolean();
        this.leftEquiJoinIndex = in.readInt();
        this.condition = (Expression)in.readObject();
        this.mapName = (String)in.readObject();
        this.rightRowProjectorSupplier = (KvRowProjector.Supplier)in.readObject();
    }

    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="the class is never serialized")
    private static final class TransientReference<T>
    implements Serializable {
        private final transient T ref;

        private TransientReference(T ref) {
            this.ref = ref;
        }
    }
}

