/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.infoschema;

import com.hazelcast.jet.sql.impl.connector.infoschema.InfoSchemaTable;
import com.hazelcast.jet.sql.impl.schema.MappingDefinition;
import com.hazelcast.sql.impl.schema.ConstantTableStatistics;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.schema.TableStatistics;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MappingsTable
extends InfoSchemaTable {
    private static final String NAME = "mappings";
    private static final List<TableField> FIELDS = Arrays.asList(new TableField("mapping_catalog", QueryDataType.VARCHAR, false), new TableField("mapping_schema", QueryDataType.VARCHAR, false), new TableField("mapping_name", QueryDataType.VARCHAR, false), new TableField("mapping_type", QueryDataType.VARCHAR, false), new TableField("mapping_options", QueryDataType.VARCHAR, false));
    private final String catalog;
    private final List<MappingDefinition> definitions;

    public MappingsTable(String catalog, String schemaName, List<MappingDefinition> definitions) {
        super(FIELDS, schemaName, NAME, (TableStatistics)new ConstantTableStatistics((long)definitions.size()));
        this.catalog = catalog;
        this.definitions = definitions;
    }

    @Override
    protected List<Object[]> rows() {
        ArrayList<Object[]> rows = new ArrayList<Object[]>(this.definitions.size());
        for (MappingDefinition definition : this.definitions) {
            Object[] row = new Object[]{this.catalog, definition.schema(), definition.name(), definition.type(), definition.options()};
            rows.add(row);
        }
        return rows;
    }
}

