/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.generator;

import com.hazelcast.internal.util.UuidUtil;
import com.hazelcast.jet.sql.impl.connector.generator.StreamSqlConnector;
import com.hazelcast.jet.sql.impl.connector.generator.StreamTable;
import com.hazelcast.jet.sql.impl.schema.JetTableFunction;
import com.hazelcast.jet.sql.impl.schema.JetTableFunctionParameter;
import com.hazelcast.sql.impl.calcite.schema.HazelcastTable;
import com.hazelcast.sql.impl.calcite.schema.HazelcastTableStatistic;
import com.hazelcast.sql.impl.schema.Table;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.schema.FunctionParameter;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.sql.type.SqlTypeName;

public final class StreamGeneratorTableFunction
extends JetTableFunction {
    public static final StreamGeneratorTableFunction GENERATE_STREAM = new StreamGeneratorTableFunction();
    private static final String SCHEMA_NAME_STREAM = "stream";
    private static final List<FunctionParameter> PARAMETERS = Collections.singletonList(new JetTableFunctionParameter(0, "rate", SqlTypeName.INTEGER, true));

    private StreamGeneratorTableFunction() {
        super(StreamSqlConnector.INSTANCE);
    }

    public List<FunctionParameter> getParameters() {
        return PARAMETERS;
    }

    @Override
    protected HazelcastTable toTable(List<Object> arguments) {
        int rate = (Integer)arguments.get(0);
        StreamTable table = StreamSqlConnector.createTable(SCHEMA_NAME_STREAM, StreamGeneratorTableFunction.randomName(), rate);
        return new HazelcastTable((Table)table, (Statistic)new HazelcastTableStatistic(Integer.MAX_VALUE));
    }

    private static String randomName() {
        return "stream_" + UuidUtil.newUnsecureUuidString().replace('-', '_');
    }
}

