/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.PredicateEx;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.row.HeapRow;
import com.hazelcast.sql.impl.row.Row;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ExpressionUtil {
    public static final ExpressionEvalContext ZERO_ARGUMENTS_CONTEXT = index -> {
        throw new IndexOutOfBoundsException("" + index);
    };

    private ExpressionUtil() {
    }

    public static PredicateEx<Object[]> filterFn(Expression<Boolean> predicate) {
        return (PredicateEx & Serializable)values -> {
            HeapRow row = new HeapRow(values);
            return Boolean.TRUE.equals(ExpressionUtil.evaluate(predicate, (Row)row));
        };
    }

    public static FunctionEx<Object[], Object[]> projectionFn(List<Expression<?>> projections) {
        return (FunctionEx & Serializable)values -> {
            HeapRow row = new HeapRow(values);
            Object[] result = new Object[projections.size()];
            for (int i = 0; i < projections.size(); ++i) {
                result[i] = ExpressionUtil.evaluate((Expression)projections.get(i), (Row)row);
            }
            return result;
        };
    }

    @Nullable
    public static Object[] join(@Nonnull Object[] leftRow, @Nonnull Object[] rightRow, @Nonnull Expression<Boolean> predicate) {
        Object[] joined = Arrays.copyOf(leftRow, leftRow.length + rightRow.length);
        System.arraycopy(rightRow, 0, joined, leftRow.length, rightRow.length);
        HeapRow row = new HeapRow(joined);
        return Boolean.TRUE.equals(ExpressionUtil.evaluate(predicate, (Row)row)) ? joined : null;
    }

    @Nonnull
    public static List<Object[]> evaluate(@Nullable Expression<Boolean> predicate, @Nullable List<Expression<?>> projection, @Nonnull List<Object[]> rows) {
        ArrayList<Object[]> evaluatedRows = new ArrayList<Object[]>();
        for (Object[] values : rows) {
            Object[] transformed = ExpressionUtil.evaluate(predicate, projection, values);
            if (transformed == null) continue;
            evaluatedRows.add(transformed);
        }
        return evaluatedRows;
    }

    @Nullable
    public static Object[] evaluate(@Nullable Expression<Boolean> predicate, @Nullable List<Expression<?>> projection, @Nonnull Object[] values) {
        HeapRow row = new HeapRow(values);
        if (predicate != null && !Boolean.TRUE.equals(ExpressionUtil.evaluate(predicate, (Row)row))) {
            return null;
        }
        if (projection == null) {
            return values;
        }
        Object[] result = new Object[projection.size()];
        for (int i = 0; i < projection.size(); ++i) {
            result[i] = ExpressionUtil.evaluate(projection.get(i), (Row)row);
        }
        return result;
    }

    public static <T> T evaluate(Expression<T> expression, Row row) {
        return (T)expression.eval(row, ZERO_ARGUMENTS_CONTEXT);
    }
}

