/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.spring;

import com.hazelcast.config.MetricsConfig;
import com.hazelcast.internal.config.DomConfigHelper;
import com.hazelcast.jet.Jet;
import com.hazelcast.jet.config.EdgeConfig;
import com.hazelcast.jet.config.InstanceConfig;
import com.hazelcast.jet.config.JetConfig;
import com.hazelcast.spring.AbstractHazelcastBeanDefinitionParser;
import com.hazelcast.spring.HazelcastConfigBeanDefinitionParser;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JetInstanceBeanDefinitionParser
extends AbstractHazelcastBeanDefinitionParser {
    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        SpringXmlBuilder springXmlBuilder = new SpringXmlBuilder(parserContext);
        return springXmlBuilder.handle(element);
    }

    private class SpringXmlBuilder
    extends AbstractHazelcastBeanDefinitionParser.SpringXmlBuilderHelper {
        private final ParserContext parserContext;
        private final BeanDefinitionBuilder builder;

        SpringXmlBuilder(ParserContext parserContext) {
            this.parserContext = parserContext;
            this.builder = BeanDefinitionBuilder.rootBeanDefinition(Jet.class).setFactoryMethod("newJetInstance").setDestroyMethodName("shutdown");
        }

        private AbstractBeanDefinition handle(Element element) {
            this.handleCommonBeanAttributes(element, this.builder, this.parserContext);
            this.configBuilder = BeanDefinitionBuilder.rootBeanDefinition(JetConfig.class).setScope(this.builder.getBeanDefinition().getScope()).setLazyInit(this.builder.getBeanDefinition().isLazyInit());
            for (Node node : DomConfigHelper.childElements((Node)element)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)node);
                if ("config".equals(nodeName)) {
                    this.configBuilder.addPropertyValue("hazelcastConfig", (Object)this.parseConfigBeanDefinition((Element)node));
                    continue;
                }
                if ("instance-config".equals(nodeName)) {
                    this.createAndFillBeanBuilder(node, InstanceConfig.class, "instanceConfig", this.configBuilder, new String[0]);
                    continue;
                }
                if ("default-edge-config".equals(nodeName)) {
                    this.createAndFillBeanBuilder(node, EdgeConfig.class, "defaultEdgeConfig", this.configBuilder, new String[0]);
                    continue;
                }
                if ("properties".equals(nodeName)) {
                    this.handleProperties(node, this.configBuilder);
                    continue;
                }
                if ("metrics-config".equals(nodeName)) {
                    this.createAndFillBeanBuilder(node, MetricsConfig.class, "metricsConfig", this.configBuilder, new String[0]);
                    continue;
                }
                throw new IllegalArgumentException("Unknown configuration for JetConfig nodeName: " + nodeName);
            }
            return this.builder.addConstructorArgValue((Object)this.configBuilder.getBeanDefinition()).getBeanDefinition();
        }

        private AbstractBeanDefinition parseConfigBeanDefinition(Element config) {
            if (config == null) {
                return this.defaultConfigBeanDefinition();
            }
            HazelcastConfigBeanDefinitionParser configParser = new HazelcastConfigBeanDefinitionParser();
            return configParser.parseInternal(config, this.parserContext);
        }

        private AbstractBeanDefinition defaultConfigBeanDefinition() {
            return BeanDefinitionBuilder.rootBeanDefinition(JetConfig.class).setFactoryMethod("defaultHazelcastConfig").getBeanDefinition();
        }
    }
}

