/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.spring;

import com.hazelcast.jet.JetInstance;
import com.hazelcast.spring.AbstractHazelcastBeanDefinitionParser;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class JetHazelcastBeanDefinitionParser
extends AbstractHazelcastBeanDefinitionParser {
    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        return new SpringXmlBuilder(parserContext).handle(element);
    }

    private class SpringXmlBuilder
    extends AbstractHazelcastBeanDefinitionParser.SpringXmlBuilderHelper {
        private final ParserContext parserContext;
        private final BeanDefinitionBuilder builder;

        SpringXmlBuilder(ParserContext parserContext) {
            this.parserContext = parserContext;
            this.builder = BeanDefinitionBuilder.rootBeanDefinition(JetInstance.class).setFactoryMethod("getHazelcastInstance");
        }

        AbstractBeanDefinition handle(Element element) {
            Node jetInstanceRefNode;
            this.handleCommonBeanAttributes(element, this.builder, this.parserContext);
            NamedNodeMap attributes = element.getAttributes();
            if (attributes != null && (jetInstanceRefNode = attributes.getNamedItem("jet-instance-ref")) != null) {
                String jetInstanceRef = this.getTextContent(jetInstanceRefNode);
                this.builder.getRawBeanDefinition().setFactoryBeanName(jetInstanceRef);
                return this.builder.addDependsOn(jetInstanceRef).getBeanDefinition();
            }
            throw new IllegalStateException("'jet-instance-ref' attribute is required for creating HazelcastInstance");
        }
    }
}

