/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.impl.execution.init.JetInitDataSerializerHook;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.Set;

public class JobRecord
implements IdentifiedDataSerializable {
    private long jobId;
    private long creationTime;
    private Data dag;
    private String dagJson;
    private JobConfig config;
    private Set<String> ownedObservables;

    public JobRecord() {
    }

    public JobRecord(long jobId, Data dag, String dagJson, JobConfig config, Set<String> ownedObservables) {
        this.jobId = jobId;
        this.creationTime = Clock.currentTimeMillis();
        this.dag = dag;
        this.dagJson = dagJson;
        this.config = config;
        this.ownedObservables = ownedObservables;
    }

    public long getJobId() {
        return this.jobId;
    }

    public String getJobNameOrId() {
        return this.config.getName() != null ? this.config.getName() : com.hazelcast.jet.Util.idToString(this.jobId);
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public Data getDag() {
        return this.dag;
    }

    public String getDagJson() {
        return this.dagJson;
    }

    public JobConfig getConfig() {
        return this.config;
    }

    public Set<String> getOwnedObservables() {
        return this.ownedObservables;
    }

    public int getFactoryId() {
        return JetInitDataSerializerHook.FACTORY_ID;
    }

    public int getClassId() {
        return 3;
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeLong(this.jobId);
        out.writeLong(this.creationTime);
        IOUtil.writeData((ObjectDataOutput)out, (Data)this.dag);
        out.writeUTF(this.dagJson);
        out.writeObject((Object)this.config);
        out.writeObject(this.ownedObservables);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.jobId = in.readLong();
        this.creationTime = in.readLong();
        this.dag = IOUtil.readData((ObjectDataInput)in);
        this.dagJson = in.readUTF();
        this.config = (JobConfig)in.readObject();
        this.ownedObservables = (Set)in.readObject();
    }

    public String toString() {
        return "JobRecord{jobId=" + com.hazelcast.jet.Util.idToString(this.jobId) + ", name=" + this.getConfig().getName() + ", creationTime=" + Util.toLocalDateTime(this.creationTime) + ", dagJson=" + this.dagJson + ", config=" + this.config + ", ownedObservables=" + this.ownedObservables + '}';
    }
}

