/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.client.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

public final class JetExportSnapshotCodec {
    public static final int REQUEST_MESSAGE_TYPE = 16648704;
    public static final int RESPONSE_MESSAGE_TYPE = 16648705;
    private static final int REQUEST_JOB_ID_FIELD_OFFSET = 16;
    private static final int REQUEST_CANCEL_JOB_FIELD_OFFSET = 24;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 25;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 13;

    private JetExportSnapshotCodec() {
    }

    public static ClientMessage encodeRequest(long jobId, String name, boolean cancelJob) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(false);
        clientMessage.setOperationName("Jet.ExportSnapshot");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[25], 49152);
        FixedSizeTypesCodec.encodeInt((byte[])initialFrame.content, (int)0, (int)16648704);
        FixedSizeTypesCodec.encodeInt((byte[])initialFrame.content, (int)12, (int)-1);
        FixedSizeTypesCodec.encodeLong((byte[])initialFrame.content, (int)16, (long)jobId);
        FixedSizeTypesCodec.encodeBoolean((byte[])initialFrame.content, (int)24, (boolean)cancelJob);
        clientMessage.add(initialFrame);
        StringCodec.encode((ClientMessage)clientMessage, (String)name);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        request.jobId = FixedSizeTypesCodec.decodeLong((byte[])initialFrame.content, (int)16);
        request.cancelJob = FixedSizeTypesCodec.decodeBoolean((byte[])initialFrame.content, (int)24);
        request.name = StringCodec.decode((ClientMessage.ForwardFrameIterator)iterator);
        return request;
    }

    public static ClientMessage encodeResponse() {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[13], 49152);
        FixedSizeTypesCodec.encodeInt((byte[])initialFrame.content, (int)0, (int)16648705);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public long jobId;
        public String name;
        public boolean cancelJob;
    }
}

