/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.pipeline;

import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.jet.pipeline.WindowDefinition;

public class SlidingWindowDefinition
extends WindowDefinition {
    private final long windowSize;
    private final long slideBy;

    SlidingWindowDefinition(long windowSize, long slideBy) {
        Preconditions.checkPositive((double)windowSize, (String)"windowSize must be positive");
        Preconditions.checkPositive((double)slideBy, (String)"slideBy must be positive");
        Preconditions.checkTrue((windowSize % slideBy == 0L ? 1 : 0) != 0, (String)("windowSize must be integer multiple of slideBy, mod(" + windowSize + ", " + slideBy + ") != 0"));
        this.windowSize = windowSize;
        this.slideBy = slideBy;
    }

    @Override
    public SlidingWindowDefinition setEarlyResultsPeriod(long earlyResultPeriodMs) {
        return (SlidingWindowDefinition)super.setEarlyResultsPeriod(earlyResultPeriodMs);
    }

    public long windowSize() {
        return this.windowSize;
    }

    public long slideBy() {
        return this.slideBy;
    }
}

