/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.processor;

import com.hazelcast.jet.core.AbstractProcessor;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.pipeline.ServiceFactory;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AbstractTransformUsingServiceP<C, S>
extends AbstractProcessor {
    protected final C serviceContext;
    protected final ServiceFactory<C, S> serviceFactory;
    S service;

    public AbstractTransformUsingServiceP(@Nonnull ServiceFactory<C, S> serviceFactory, @Nullable C serviceContext) {
        this.serviceContext = serviceContext;
        this.serviceFactory = serviceFactory;
    }

    @Override
    protected void init(@Nonnull Processor.Context context) throws Exception {
        this.service = this.serviceFactory.createServiceFn().apply((Object)context, this.serviceContext);
    }

    @Override
    public boolean isCooperative() {
        return this.serviceFactory.isCooperative();
    }

    @Override
    public void close() throws Exception {
        if (this.service != null) {
            this.serviceFactory.destroyServiceFn().accept(this.service);
        }
        this.service = null;
    }
}

