/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.pipeline;

import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.function.BiPredicateEx;
import com.hazelcast.function.ComparatorEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.PredicateEx;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.Traversers;
import com.hazelcast.jet.aggregate.AggregateOperation1;
import com.hazelcast.jet.aggregate.AggregateOperation2;
import com.hazelcast.jet.aggregate.AggregateOperation3;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.function.TriFunction;
import com.hazelcast.jet.impl.pipeline.BatchStageWithKeyImpl;
import com.hazelcast.jet.impl.pipeline.ComputeStageImplBase;
import com.hazelcast.jet.impl.pipeline.FunctionAdapter;
import com.hazelcast.jet.impl.pipeline.PipelineImpl;
import com.hazelcast.jet.impl.pipeline.transform.AbstractTransform;
import com.hazelcast.jet.impl.pipeline.transform.AggregateTransform;
import com.hazelcast.jet.impl.pipeline.transform.Transform;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.pipeline.BatchStage;
import com.hazelcast.jet.pipeline.BatchStageWithKey;
import com.hazelcast.jet.pipeline.JoinClause;
import com.hazelcast.jet.pipeline.ServiceFactory;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

public class BatchStageImpl<T>
extends ComputeStageImplBase<T>
implements BatchStage<T> {
    BatchStageImpl(@Nonnull Transform transform, @Nonnull PipelineImpl pipeline) {
        super(transform, DO_NOT_ADAPT, pipeline);
    }

    public BatchStageImpl(@Nonnull Transform transform, FunctionAdapter ignored, @Nonnull PipelineImpl pipeline) {
        this(transform, pipeline);
    }

    BatchStageImpl(BatchStageImpl<T> toCopy, boolean rebalanceOutput) {
        super(toCopy, rebalanceOutput);
    }

    <K> BatchStageImpl(BatchStageImpl<T> toCopy, FunctionEx<? super T, ? extends K> keyFn) {
        super(toCopy, keyFn);
    }

    @Override
    @Nonnull
    public <K> BatchStageWithKey<T, K> groupingKey(@Nonnull FunctionEx<? super T, ? extends K> keyFn) {
        Util.checkSerializable(keyFn, "keyFn");
        return new BatchStageWithKeyImpl<T, K>(this, keyFn);
    }

    @Override
    @Nonnull
    public <K> BatchStage<T> rebalance(@Nonnull FunctionEx<? super T, ? extends K> keyFn) {
        Util.checkSerializable(keyFn, "keyFn");
        return new BatchStageImpl<T>(this, keyFn);
    }

    @Override
    @Nonnull
    public BatchStage<T> rebalance() {
        return new BatchStageImpl<T>(this, true);
    }

    @Override
    @Nonnull
    public BatchStage<T> sort() {
        return (BatchStage)this.attachSort(null);
    }

    @Override
    @Nonnull
    public BatchStage<T> sort(@Nonnull ComparatorEx<? super T> comparator) {
        return (BatchStage)this.attachSort(comparator);
    }

    @Override
    @Nonnull
    public <R> BatchStage<R> map(@Nonnull FunctionEx<? super T, ? extends R> mapFn) {
        return (BatchStage)this.attachMap(mapFn);
    }

    @Override
    @Nonnull
    public BatchStage<T> filter(@Nonnull PredicateEx<T> filterFn) {
        return (BatchStage)this.attachFilter(filterFn);
    }

    @Override
    @Nonnull
    public <R> BatchStage<R> flatMap(@Nonnull FunctionEx<? super T, ? extends Traverser<R>> flatMapFn) {
        return (BatchStage)this.attachFlatMap(flatMapFn);
    }

    @Override
    @Nonnull
    public <S, R> BatchStage<R> mapStateful(@Nonnull SupplierEx<? extends S> createFn, @Nonnull BiFunctionEx<? super S, ? super T, ? extends R> mapFn) {
        return (BatchStage)this.attachGlobalMapStateful(createFn, mapFn);
    }

    @Override
    @Nonnull
    public <S> BatchStage<T> filterStateful(@Nonnull SupplierEx<? extends S> createFn, @Nonnull BiPredicateEx<? super S, ? super T> filterFn) {
        return (BatchStage)this.attachGlobalMapStateful(createFn, (BiFunctionEx & Serializable)(s, t) -> filterFn.test(s, t) ? t : null);
    }

    @Override
    @Nonnull
    public <S, R> BatchStage<R> flatMapStateful(@Nonnull SupplierEx<? extends S> createFn, @Nonnull BiFunctionEx<? super S, ? super T, ? extends Traverser<R>> flatMapFn) {
        return (BatchStage)this.attachGlobalFlatMapStateful(createFn, flatMapFn);
    }

    @Override
    @Nonnull
    public <S, R> BatchStage<R> mapUsingService(@Nonnull ServiceFactory<?, S> serviceFactory, @Nonnull BiFunctionEx<? super S, ? super T, ? extends R> mapFn) {
        return (BatchStage)this.attachMapUsingService(serviceFactory, mapFn);
    }

    @Override
    @Nonnull
    public <S, R> BatchStage<R> mapUsingServiceAsync(@Nonnull ServiceFactory<?, S> serviceFactory, int maxConcurrentOps, boolean preserveOrder, @Nonnull BiFunctionEx<? super S, ? super T, ? extends CompletableFuture<R>> mapAsyncFn) {
        return (BatchStage)this.attachMapUsingServiceAsync(serviceFactory, maxConcurrentOps, preserveOrder, (BiFunctionEx & Serializable)(s, t) -> ((CompletableFuture)mapAsyncFn.apply(s, t)).thenApply(Traversers::singleton));
    }

    @Override
    @Nonnull
    public <S, R> BatchStage<R> mapUsingServiceAsyncBatched(@Nonnull ServiceFactory<?, S> serviceFactory, int maxBatchSize, @Nonnull BiFunctionEx<? super S, ? super List<T>, ? extends CompletableFuture<List<R>>> mapAsyncFn) {
        return (BatchStage)this.attachMapUsingServiceAsyncBatched(serviceFactory, maxBatchSize, (BiFunctionEx & Serializable)(s, t) -> ((CompletableFuture)mapAsyncFn.apply(s, t)).thenApply(list -> Util.toList(list, Traversers::singleton)));
    }

    @Override
    @Nonnull
    public <S> BatchStage<T> filterUsingService(@Nonnull ServiceFactory<?, S> serviceFactory, @Nonnull BiPredicateEx<? super S, ? super T> filterFn) {
        return (BatchStage)this.attachFilterUsingService(serviceFactory, filterFn);
    }

    @Override
    @Nonnull
    public <S, R> BatchStage<R> flatMapUsingService(@Nonnull ServiceFactory<?, S> serviceFactory, @Nonnull BiFunctionEx<? super S, ? super T, ? extends Traverser<R>> flatMapFn) {
        return (BatchStage)this.attachFlatMapUsingService(serviceFactory, flatMapFn);
    }

    @Override
    @Nonnull
    public BatchStage<T> merge(@Nonnull BatchStage<? extends T> other) {
        return (BatchStage)this.attachMerge(other);
    }

    @Override
    @Nonnull
    public <K, T1_IN, T1, R> BatchStage<R> hashJoin(@Nonnull BatchStage<T1_IN> stage1, @Nonnull JoinClause<K, ? super T, ? super T1_IN, ? extends T1> joinClause1, @Nonnull BiFunctionEx<T, T1, R> mapToOutputFn) {
        return (BatchStage)this.attachHashJoin(stage1, joinClause1, mapToOutputFn);
    }

    @Override
    @Nonnull
    public <K, T1_IN, T1, R> BatchStage<R> innerHashJoin(@Nonnull BatchStage<T1_IN> stage1, @Nonnull JoinClause<K, ? super T, ? super T1_IN, ? extends T1> joinClause1, @Nonnull BiFunctionEx<T, T1, R> mapToOutputFn) {
        BiFunctionEx & Serializable finalOutputFn = (BiFunctionEx & Serializable)(leftSide, rightSide) -> {
            if (leftSide == null || rightSide == null) {
                return null;
            }
            return mapToOutputFn.apply(leftSide, rightSide);
        };
        return (BatchStage)this.attachHashJoin(stage1, joinClause1, finalOutputFn);
    }

    @Override
    @Nonnull
    public <K1, K2, T1_IN, T2_IN, T1, T2, R> BatchStage<R> hashJoin2(@Nonnull BatchStage<T1_IN> stage1, @Nonnull JoinClause<K1, ? super T, ? super T1_IN, ? extends T1> joinClause1, @Nonnull BatchStage<T2_IN> stage2, @Nonnull JoinClause<K2, ? super T, ? super T2_IN, ? extends T2> joinClause2, @Nonnull TriFunction<T, T1, T2, R> mapToOutputFn) {
        return (BatchStage)this.attachHashJoin2(stage1, joinClause1, stage2, joinClause2, mapToOutputFn);
    }

    @Override
    @Nonnull
    public <K1, K2, T1_IN, T2_IN, T1, T2, R> BatchStage<R> innerHashJoin2(@Nonnull BatchStage<T1_IN> stage1, @Nonnull JoinClause<K1, ? super T, ? super T1_IN, ? extends T1> joinClause1, @Nonnull BatchStage<T2_IN> stage2, @Nonnull JoinClause<K2, ? super T, ? super T2_IN, ? extends T2> joinClause2, @Nonnull TriFunction<T, T1, T2, R> mapToOutputFn) {
        TriFunction<Object, Object, Object, Object> finalOutputFn = (leftSide, middle, rightSide) -> {
            if (leftSide == null || middle == null || rightSide == null) {
                return null;
            }
            return mapToOutputFn.apply(leftSide, middle, rightSide);
        };
        return (BatchStage)this.attachHashJoin2(stage1, joinClause1, stage2, joinClause2, finalOutputFn);
    }

    @Override
    @Nonnull
    public <R> BatchStage<R> aggregate(@Nonnull AggregateOperation1<? super T, ?, ? extends R> aggrOp) {
        return (BatchStage)this.attach(new AggregateTransform(Collections.singletonList(this.transform), aggrOp), this.fnAdapter);
    }

    @Override
    @Nonnull
    public <T1, R> BatchStage<R> aggregate2(@Nonnull BatchStage<T1> stage1, @Nonnull AggregateOperation2<? super T, ? super T1, ?, ? extends R> aggrOp) {
        return (BatchStage)this.attach(new AggregateTransform(Arrays.asList(this.transform, BatchStageImpl.transformOf(stage1)), aggrOp), Collections.singletonList(stage1), DO_NOT_ADAPT);
    }

    @Override
    @Nonnull
    public <T1, T2, R> BatchStage<R> aggregate3(@Nonnull BatchStage<T1> stage1, @Nonnull BatchStage<T2> stage2, @Nonnull AggregateOperation3<? super T, ? super T1, ? super T2, ?, ? extends R> aggrOp) {
        return (BatchStage)this.attach(new AggregateTransform(Arrays.asList(this.transform, BatchStageImpl.transformOf(stage1), BatchStageImpl.transformOf(stage2)), aggrOp), Arrays.asList(stage1, stage2), DO_NOT_ADAPT);
    }

    @Override
    @Nonnull
    public BatchStage<T> peek(@Nonnull PredicateEx<? super T> shouldLogFn, @Nonnull FunctionEx<? super T, ? extends CharSequence> toStringFn) {
        return (BatchStage)this.attachPeek(shouldLogFn, toStringFn);
    }

    @Override
    @Nonnull
    public <R> BatchStage<R> customTransform(@Nonnull String stageName, @Nonnull ProcessorMetaSupplier procSupplier) {
        return (BatchStage)this.attachCustomTransform(stageName, procSupplier);
    }

    @Override
    @Nonnull
    public BatchStage<T> setLocalParallelism(int localParallelism) {
        super.setLocalParallelism(localParallelism);
        return this;
    }

    @Override
    @Nonnull
    public BatchStage<T> setName(@Nonnull String name) {
        super.setName(name);
        return this;
    }

    @Override
    <RET> RET newStage(@Nonnull AbstractTransform transform, @Nonnull FunctionAdapter fnAdapter) {
        return (RET)new BatchStageImpl<T>(transform, this.pipelineImpl);
    }
}

