/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.client.impl.client.DistributedObjectInfo;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientGetDistributedObjectsCodec;
import com.hazelcast.client.impl.spi.impl.ClientInvocation;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.jet.Job;
import com.hazelcast.jet.config.JetConfig;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.impl.AbstractJetInstance;
import com.hazelcast.jet.impl.ClientJobProxy;
import com.hazelcast.jet.impl.JobSummary;
import com.hazelcast.jet.impl.client.protocol.codec.JetExistsDistributedObjectCodec;
import com.hazelcast.jet.impl.client.protocol.codec.JetGetJobIdsByNameCodec;
import com.hazelcast.jet.impl.client.protocol.codec.JetGetJobIdsCodec;
import com.hazelcast.jet.impl.client.protocol.codec.JetGetJobSummaryListCodec;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.logging.ILogger;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nonnull;

public class JetClientInstanceImpl
extends AbstractJetInstance {
    private final HazelcastClientInstanceImpl client;
    private final SerializationService serializationService;

    public JetClientInstanceImpl(HazelcastClientInstanceImpl hazelcastInstance) {
        super((HazelcastInstance)hazelcastInstance);
        this.client = hazelcastInstance;
        this.serializationService = this.client.getSerializationService();
        ExceptionUtil.registerJetExceptions(hazelcastInstance.getClientExceptionFactory());
    }

    @Override
    @Nonnull
    public JetConfig getConfig() {
        throw new UnsupportedOperationException("Jet Configuration is not available on the client");
    }

    @Override
    @Nonnull
    public List<Job> getJobs() {
        return (List)this.invokeRequestOnMasterAndDecodeResponse(JetGetJobIdsCodec.encodeRequest(), resp -> {
            List<Long> jobs = JetGetJobIdsCodec.decodeResponse(resp);
            return Util.toList(jobs, jobId -> new ClientJobProxy(this, (long)jobId));
        });
    }

    @Nonnull
    public List<JobSummary> getJobSummaryList() {
        return (List)this.invokeRequestOnMasterAndDecodeResponse(JetGetJobSummaryListCodec.encodeRequest(), response -> JetGetJobSummaryListCodec.decodeResponse(response));
    }

    @Nonnull
    public HazelcastClientInstanceImpl getHazelcastClient() {
        return this.client;
    }

    @Override
    public boolean existsDistributedObject(@Nonnull String serviceName, @Nonnull String objectName) {
        return (Boolean)this.invokeRequestOnAnyMemberAndDecodeResponse(JetExistsDistributedObjectCodec.encodeRequest(serviceName, objectName), response -> JetExistsDistributedObjectCodec.decodeResponse(response));
    }

    public List<DistributedObjectInfo> getDistributedObjects() {
        return (List)this.invokeRequestOnAnyMemberAndDecodeResponse(ClientGetDistributedObjectsCodec.encodeRequest(), response -> ClientGetDistributedObjectsCodec.decodeResponse((ClientMessage)response));
    }

    @Override
    public List<Long> getJobIdsByName(String name) {
        return (List)this.invokeRequestOnMasterAndDecodeResponse(JetGetJobIdsByNameCodec.encodeRequest(name), response -> JetGetJobIdsByNameCodec.decodeResponse(response));
    }

    @Override
    public Job newJobProxy(long jobId, Object jobDefinition, JobConfig config) {
        return new ClientJobProxy(this, jobId, jobDefinition, config);
    }

    @Override
    public Job newJobProxy(long jobId) {
        return new ClientJobProxy(this, jobId);
    }

    @Override
    public ILogger getLogger() {
        return this.client.getLoggingService().getLogger(this.getClass());
    }

    private <S> S invokeRequestOnMasterAndDecodeResponse(ClientMessage request, Function<ClientMessage, Object> decoder) {
        UUID masterUuid = this.client.getClientClusterService().getMasterMember().getUuid();
        return this.invokeRequestAndDecodeResponse(masterUuid, request, decoder);
    }

    private <S> S invokeRequestOnAnyMemberAndDecodeResponse(ClientMessage request, Function<ClientMessage, Object> decoder) {
        return this.invokeRequestAndDecodeResponse(null, request, decoder);
    }

    private <S> S invokeRequestAndDecodeResponse(UUID uuid, ClientMessage request, Function<ClientMessage, Object> decoder) {
        ClientInvocation invocation = new ClientInvocation(this.client, request, null, uuid);
        try {
            ClientMessage response = (ClientMessage)invocation.invoke().get();
            return (S)this.serializationService.toObject(decoder.apply(response));
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }
}

