/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientFailoverConfig;
import com.hazelcast.client.impl.clientside.HazelcastClientProxy;
import com.hazelcast.config.Config;
import com.hazelcast.config.ConfigAccessor;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.ServiceConfig;
import com.hazelcast.config.matcher.MatchingPointConfigPatternMatcher;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.instance.BuildInfoProvider;
import com.hazelcast.instance.impl.HazelcastInstanceFactory;
import com.hazelcast.instance.impl.HazelcastInstanceImpl;
import com.hazelcast.instance.impl.HazelcastInstanceProxy;
import com.hazelcast.instance.impl.NodeContext;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.config.JetConfig;
import com.hazelcast.jet.core.JetProperties;
import com.hazelcast.jet.impl.JetBootstrap;
import com.hazelcast.jet.impl.JetClientInstanceImpl;
import com.hazelcast.jet.impl.JetNodeContext;
import com.hazelcast.jet.impl.JetService;
import com.hazelcast.jet.impl.config.ConfigProvider;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.spi.merge.DiscardMergePolicy;
import com.hazelcast.spi.properties.ClusterProperty;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.spi.properties.HazelcastProperty;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import javax.annotation.Nonnull;

public final class Jet {
    private static final ILogger LOGGER = Logger.getLogger(Jet.class);

    private Jet() {
    }

    @Nonnull
    public static JetInstance bootstrappedInstance() {
        return JetBootstrap.getInstance();
    }

    @Nonnull
    public static JetInstance newJetInstance() {
        JetConfig config = ConfigProvider.locateAndGetJetConfig();
        return Jet.newJetInstance(config);
    }

    @Nonnull
    public static JetInstance newJetInstance(@Nonnull JetConfig config) {
        Preconditions.checkNotNull((Object)config, (String)"config");
        return Jet.newJetInstanceImpl(config, cfg -> HazelcastInstanceFactory.newHazelcastInstance((Config)cfg, (String)cfg.getInstanceName(), (NodeContext)new JetNodeContext()));
    }

    @Nonnull
    public static JetInstance newJetClient() {
        ClientConfig clientConfig = ConfigProvider.locateAndGetClientConfig();
        return Jet.newJetClient(clientConfig);
    }

    @Nonnull
    public static JetInstance newJetClient(@Nonnull ClientConfig config) {
        Preconditions.checkNotNull((Object)config, (String)"config");
        return Jet.getJetClientInstance(HazelcastClient.newHazelcastClient((ClientConfig)config));
    }

    @Nonnull
    public static JetInstance newJetFailoverClient(@Nonnull ClientFailoverConfig config) {
        Preconditions.checkNotNull((Object)config, (String)"config");
        return Jet.getJetClientInstance(HazelcastClient.newHazelcastFailoverClient((ClientFailoverConfig)config));
    }

    @Nonnull
    public static JetInstance newJetFailoverClient() {
        return Jet.getJetClientInstance(HazelcastClient.newHazelcastFailoverClient());
    }

    public static void shutdownAll() {
        HazelcastClient.shutdownAll();
        Hazelcast.shutdownAll();
    }

    static JetInstance newJetInstanceImpl(JetConfig config, Function<Config, HazelcastInstance> newHzFn) {
        Jet.configureJetService(config);
        HazelcastInstanceImpl hzImpl = ((HazelcastInstanceProxy)newHzFn.apply(config.getHazelcastConfig())).getOriginal();
        JetService jetService = (JetService)hzImpl.node.nodeEngine.getService("hz:impl:jetService");
        return jetService.getJetInstance();
    }

    static JetClientInstanceImpl getJetClientInstance(HazelcastInstance client) {
        return new JetClientInstanceImpl(((HazelcastClientProxy)client).client);
    }

    private static void assertHazelcastVersion() {
        String hzVersion = BuildInfoProvider.getBuildInfo().getVersion();
        try (InputStream resource = Jet.class.getClassLoader().getResourceAsStream("jet-runtime.properties");){
            Properties p = new Properties();
            p.load(resource);
            String jetHzVersion = p.getProperty("jet.hazelcast.version");
            if (!hzVersion.equals(jetHzVersion)) {
                boolean errorOnMismatch;
                String message = "Jet uses Hazelcast IMDG version " + jetHzVersion + " however version " + hzVersion + " was found in the classpath.  As Jet already shades Hazelcast jars there is no need to explicitly add a dependency to it.";
                boolean bl = errorOnMismatch = !Jet.versionCheckDisabled();
                if (errorOnMismatch) {
                    throw new JetException(message);
                }
                LOGGER.warning(message);
            }
        }
        catch (IOException e) {
            LOGGER.warning("Could not read the file jet-runtime.properties", (Throwable)e);
        }
    }

    private static boolean versionCheckDisabled() {
        String rawValue = System.getProperty(JetProperties.JET_IMDG_VERSION_CHECK_DISABLED.getName(), JetProperties.JET_IMDG_VERSION_CHECK_DISABLED.getDefaultValue());
        return Boolean.parseBoolean(rawValue);
    }

    private static synchronized void configureJetService(JetConfig jetConfig) {
        HazelcastProperty loggingDetails;
        Config hzConfig = jetConfig.getHazelcastConfig();
        if (!(hzConfig.getConfigPatternMatcher() instanceof MatchingPointConfigPatternMatcher)) {
            throw new UnsupportedOperationException("Custom config pattern matcher is not supported in Jet");
        }
        Properties jetProps = jetConfig.getProperties();
        Properties hzProperties = hzConfig.getProperties();
        String hzHookEnabled = Optional.ofNullable(hzConfig.getProperty(ClusterProperty.SHUTDOWNHOOK_ENABLED.getName())).orElse(ClusterProperty.SHUTDOWNHOOK_ENABLED.getDefaultValue());
        if (!jetProps.containsKey(JetProperties.JET_SHUTDOWNHOOK_ENABLED)) {
            jetProps.setProperty(JetProperties.JET_SHUTDOWNHOOK_ENABLED.getName(), hzHookEnabled);
        }
        if ((loggingDetails = ClusterProperty.LOGGING_ENABLE_DETAILS).getSystemProperty() == null && !jetProps.containsKey(loggingDetails) && !hzProperties.containsKey(loggingDetails)) {
            jetProps.setProperty(loggingDetails.getName(), "false");
        }
        hzConfig.setProperty(ClusterProperty.SHUTDOWNHOOK_ENABLED.getName(), "false");
        for (String prop : jetProps.stringPropertyNames()) {
            hzProperties.setProperty(prop, jetProps.getProperty(prop));
        }
        ConfigAccessor.getServicesConfig((Config)hzConfig).addServiceConfig(new ServiceConfig().setEnabled(false).setName("hz:impl:jetService").setClassName(JetService.class.getName()).setConfigObject((Object)jetConfig));
        MapConfig internalMapConfig = new MapConfig("__jet.*").setBackupCount(jetConfig.getInstanceConfig().getBackupCount()).setStatisticsEnabled(true);
        internalMapConfig.getMergePolicyConfig().setPolicy(DiscardMergePolicy.class.getName());
        HazelcastProperties properties = new HazelcastProperties(hzProperties);
        MapConfig resultsMapConfig = new MapConfig(internalMapConfig).setName("__jet.results").setTimeToLiveSeconds(properties.getSeconds(JetProperties.JOB_RESULTS_TTL_SECONDS));
        MapConfig metricsMapConfig = new MapConfig(internalMapConfig).setName("__jet.results.metrics").setTimeToLiveSeconds(properties.getSeconds(JetProperties.JOB_RESULTS_TTL_SECONDS));
        hzConfig.addMapConfig(internalMapConfig).addMapConfig(resultsMapConfig).addMapConfig(metricsMapConfig);
        if (jetConfig.getInstanceConfig().isLosslessRestartEnabled() && !hzConfig.getHotRestartPersistenceConfig().isEnabled()) {
            LOGGER.warning("Lossless Restart is enabled but Hot Restart is disabled. Auto-enabling Hot Restart. The following path will be used: " + hzConfig.getHotRestartPersistenceConfig().getBaseDir());
            hzConfig.getHotRestartPersistenceConfig().setEnabled(true);
        }
    }

    static {
        JetBootstrap.configureLogging();
        Jet.assertHazelcastVersion();
    }
}

