/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.core.metrics;

import com.hazelcast.internal.serialization.DataSerializerHook;
import com.hazelcast.internal.serialization.impl.FactoryIdHelper;
import com.hazelcast.jet.core.metrics.JobMetrics;
import com.hazelcast.jet.core.metrics.Measurement;
import com.hazelcast.nio.serialization.DataSerializableFactory;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.annotation.PrivateApi;

@PrivateApi
public class MetricsDataSerializerHook
implements DataSerializerHook {
    public static final int JOB_METRICS = 0;
    public static final int MEASUREMENT = 1;
    public static final int FACTORY_ID = FactoryIdHelper.getFactoryId((String)"hazelcast.serialization.ds.jet.job_metrics", (int)-10005);

    public int getFactoryId() {
        return FACTORY_ID;
    }

    public DataSerializableFactory createFactory() {
        return new Factory();
    }

    private static class Factory
    implements DataSerializableFactory {
        private Factory() {
        }

        public IdentifiedDataSerializable create(int typeId) {
            switch (typeId) {
                case 0: {
                    return new JobMetrics();
                }
                case 1: {
                    return new Measurement();
                }
            }
            throw new IllegalArgumentException("Unknown type id " + typeId);
        }
    }
}

