/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.pipeline;

import com.hazelcast.function.BiConsumerEx;
import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.function.BiPredicateEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.Util;
import com.hazelcast.jet.aggregate.AggregateOperation1;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.function.TriFunction;
import com.hazelcast.jet.function.TriPredicate;
import com.hazelcast.jet.pipeline.GeneralStage;
import com.hazelcast.jet.pipeline.ServiceFactories;
import com.hazelcast.jet.pipeline.ServiceFactory;
import com.hazelcast.map.IMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

public interface GeneralStageWithKey<T, K> {
    @Nonnull
    public FunctionEx<? super T, ? extends K> keyFn();

    @Nonnull
    public <S, R> GeneralStage<R> mapStateful(@Nonnull SupplierEx<? extends S> var1, @Nonnull TriFunction<? super S, ? super K, ? super T, ? extends R> var2);

    @Nonnull
    public <S> GeneralStage<T> filterStateful(@Nonnull SupplierEx<? extends S> var1, @Nonnull BiPredicateEx<? super S, ? super T> var2);

    @Nonnull
    public <S, R> GeneralStage<R> flatMapStateful(@Nonnull SupplierEx<? extends S> var1, @Nonnull TriFunction<? super S, ? super K, ? super T, ? extends Traverser<R>> var2);

    @Nonnull
    default public <A, R> GeneralStage<Map.Entry<K, R>> rollingAggregate(@Nonnull AggregateOperation1<? super T, A, ? extends R> aggrOp) {
        BiConsumerEx accumulateFn = aggrOp.accumulateFn();
        FunctionEx exportFn = aggrOp.exportFn();
        return this.mapStateful(aggrOp.createFn(), (acc, key, item) -> {
            accumulateFn.accept(acc, item);
            return Util.entry(key, exportFn.apply(acc));
        });
    }

    @Nonnull
    public <S, R> GeneralStage<R> mapUsingService(@Nonnull ServiceFactory<?, S> var1, @Nonnull TriFunction<? super S, ? super K, ? super T, ? extends R> var2);

    @Nonnull
    default public <S, R> GeneralStage<R> mapUsingServiceAsync(@Nonnull ServiceFactory<?, S> serviceFactory, @Nonnull TriFunction<? super S, ? super K, ? super T, CompletableFuture<R>> mapAsyncFn) {
        return this.mapUsingServiceAsync(serviceFactory, 4, true, mapAsyncFn);
    }

    @Nonnull
    public <S, R> GeneralStage<R> mapUsingServiceAsync(@Nonnull ServiceFactory<?, S> var1, int var2, boolean var3, @Nonnull TriFunction<? super S, ? super K, ? super T, CompletableFuture<R>> var4);

    @Nonnull
    public <S, R> GeneralStage<R> mapUsingServiceAsyncBatched(@Nonnull ServiceFactory<?, S> var1, int var2, @Nonnull BiFunctionEx<? super S, ? super List<T>, ? extends CompletableFuture<List<R>>> var3);

    @Nonnull
    public <S, R> GeneralStage<R> mapUsingServiceAsyncBatched(@Nonnull ServiceFactory<?, S> var1, int var2, @Nonnull TriFunction<? super S, ? super List<K>, ? super List<T>, ? extends CompletableFuture<List<R>>> var3);

    @Nonnull
    public <S> GeneralStage<T> filterUsingService(@Nonnull ServiceFactory<?, S> var1, @Nonnull TriPredicate<? super S, ? super K, ? super T> var2);

    @Nonnull
    public <S, R> GeneralStage<R> flatMapUsingService(@Nonnull ServiceFactory<?, S> var1, @Nonnull TriFunction<? super S, ? super K, ? super T, ? extends Traverser<R>> var2);

    @Nonnull
    default public <V, R> GeneralStage<R> mapUsingIMap(@Nonnull String mapName, @Nonnull BiFunctionEx<? super T, ? super V, ? extends R> mapFn) {
        return this.mapUsingServiceAsync(ServiceFactories.iMapService(mapName), 4, true, (map, key, item) -> map.getAsync(key).toCompletableFuture().thenApply(value -> mapFn.apply(item, value)));
    }

    @Nonnull
    default public <V, R> GeneralStage<R> mapUsingIMap(@Nonnull IMap<K, V> iMap, @Nonnull BiFunctionEx<? super T, ? super V, ? extends R> mapFn) {
        return this.mapUsingIMap(iMap.getName(), mapFn);
    }

    @Nonnull
    public <R> GeneralStage<R> customTransform(@Nonnull String var1, @Nonnull SupplierEx<Processor> var2);

    @Nonnull
    public <R> GeneralStage<R> customTransform(@Nonnull String var1, @Nonnull ProcessorSupplier var2);

    @Nonnull
    public <R> GeneralStage<R> customTransform(@Nonnull String var1, @Nonnull ProcessorMetaSupplier var2);
}

