/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.util;

import com.hazelcast.jet.Util;
import com.hazelcast.logging.AbstractLogger;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LogEvent;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class PrefixedLogger
extends AbstractLogger {
    private final ILogger wrapped;
    private final String prefix;

    PrefixedLogger(ILogger wrapped, String prefix) {
        this.wrapped = wrapped;
        this.prefix = "[" + prefix + "] ";
    }

    public static ILogger prefixedLogger(ILogger logger, String prefix) {
        return new PrefixedLogger(logger, prefix);
    }

    public static String prefix(String jobName, long jobId, String vertexName) {
        return PrefixedLogger.prefix(jobName, jobId, vertexName, null);
    }

    public static String prefix(String jobName, long jobId, String vertexName, int processorIndex) {
        return PrefixedLogger.prefix(jobName, jobId, vertexName, "#" + processorIndex);
    }

    public static String prefix(String jobName, long jobId, String vertexName, String subClass) {
        String jobIdentification = jobName != null ? jobName : Util.idToString(jobId);
        return jobIdentification + "/" + vertexName + (subClass == null ? "" : subClass);
    }

    public void log(Level level, String message) {
        this.wrapped.log(level, this.prefix + message);
    }

    public void log(Level level, String message, Throwable thrown) {
        this.wrapped.log(level, this.prefix + message, thrown);
    }

    public void log(LogEvent logEvent) {
        LogRecord logRecord = logEvent.getLogRecord();
        logRecord.setMessage(this.prefix + logRecord.getMessage());
        this.wrapped.log(logEvent);
    }

    public Level getLevel() {
        return this.wrapped.getLevel();
    }

    public boolean isLoggable(Level level) {
        return this.wrapped.isLoggable(level);
    }
}

