/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.jet.core.JobSuspensionCause;
import com.hazelcast.jet.impl.execution.init.JetInitDataSerializerHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import javax.annotation.Nonnull;

public class JobSuspensionCauseImpl
implements JobSuspensionCause,
IdentifiedDataSerializable {
    private static final JobSuspensionCauseImpl REQUESTED_BY_USER = new JobSuspensionCauseImpl(null);
    private String error;

    public JobSuspensionCauseImpl() {
    }

    private JobSuspensionCauseImpl(String error) {
        this.error = error;
    }

    @Override
    public boolean requestedByUser() {
        return this.error == null;
    }

    @Override
    public boolean dueToError() {
        return this.error != null;
    }

    @Override
    public String errorCause() {
        if (this.error == null) {
            throw new IllegalStateException("Suspension not caused by an error");
        }
        return this.error;
    }

    @Override
    @Nonnull
    public String description() {
        if (this.error == null) {
            return "Requested by user";
        }
        return this.error;
    }

    public String toString() {
        return this.description();
    }

    public int getFactoryId() {
        return JetInitDataSerializerHook.FACTORY_ID;
    }

    public int getClassId() {
        return 43;
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject((Object)this.error);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.error = (String)in.readObject();
    }

    static JobSuspensionCauseImpl causedBy(String cause) {
        return cause == null ? REQUESTED_BY_USER : new JobSuspensionCauseImpl(cause);
    }
}

