/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.core;

import com.hazelcast.function.SupplierEx;
import com.hazelcast.internal.json.JsonArray;
import com.hazelcast.internal.json.JsonObject;
import com.hazelcast.internal.json.JsonValue;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.jet.core.Edge;
import com.hazelcast.jet.core.JetDataSerializerHook;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.impl.TopologicalSorter;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DAG
implements IdentifiedDataSerializable,
Iterable<Vertex> {
    private final Set<Edge> edges = new LinkedHashSet<Edge>();
    private final Map<String, Vertex> nameToVertex = new HashMap<String, Vertex>();
    private final Set<Vertex> verticesByIdentity = Collections.newSetFromMap(new IdentityHashMap());

    @Nonnull
    public Vertex newVertex(@Nonnull String name, @Nonnull SupplierEx<? extends Processor> simpleSupplier) {
        return this.addVertex(new Vertex(name, simpleSupplier));
    }

    @Nonnull
    public Vertex newUniqueVertex(@Nonnull String namePrefix, @Nonnull SupplierEx<? extends Processor> simpleSupplier) {
        return this.addVertex(new Vertex(this.uniqueName(namePrefix), simpleSupplier));
    }

    @Nonnull
    public Vertex newVertex(@Nonnull String name, @Nonnull ProcessorSupplier processorSupplier) {
        return this.addVertex(new Vertex(name, processorSupplier));
    }

    @Nonnull
    public Vertex newUniqueVertex(@Nonnull String namePrefix, @Nonnull ProcessorSupplier processorSupplier) {
        return this.addVertex(new Vertex(this.uniqueName(namePrefix), processorSupplier));
    }

    @Nonnull
    public Vertex newVertex(@Nonnull String name, @Nonnull ProcessorMetaSupplier metaSupplier) {
        return this.addVertex(new Vertex(name, metaSupplier));
    }

    @Nonnull
    public Vertex newUniqueVertex(@Nonnull String namePrefix, @Nonnull ProcessorMetaSupplier metaSupplier) {
        return this.addVertex(new Vertex(this.uniqueName(namePrefix), metaSupplier));
    }

    @Nonnull
    public DAG vertex(@Nonnull Vertex vertex) {
        this.addVertex(vertex);
        return this;
    }

    @Nonnull
    public DAG edge(@Nonnull Edge edge) {
        if (edge.getDestination() == null) {
            throw new IllegalArgumentException("Edge has no destination");
        }
        assert (edge.getDestName() != null);
        if (!this.containsVertex(edge.getSource())) {
            throw new IllegalArgumentException(this.containsVertexName(edge.getSource()) ? "This DAG has a vertex called '" + edge.getSourceName() + "', but the supplied edge's source is a different vertex with the same name" : "Source vertex '" + edge.getSourceName() + "' is not in this DAG");
        }
        if (!this.containsVertex(edge.getDestination())) {
            throw new IllegalArgumentException(this.containsVertexName(edge.getDestination()) ? "This DAG has a vertex called '" + edge.getDestName() + "', but the supplied edge's destination is a different vertex with the same name" : "Destination vertex '" + edge.getDestName() + "' is not in this DAG");
        }
        if (this.getInboundEdges(edge.getDestName()).stream().anyMatch(e -> e.getDestOrdinal() == edge.getDestOrdinal())) {
            throw new IllegalArgumentException("Vertex '" + edge.getDestName() + "' already has an inbound edge at ordinal " + edge.getDestOrdinal() + (edge.getSourceOrdinal() == 0 && edge.getDestOrdinal() == 0 ? ", use Edge.from().to() to specify another ordinal" : ""));
        }
        if (this.getOutboundEdges(edge.getSourceName()).stream().anyMatch(e -> e.getSourceOrdinal() == edge.getSourceOrdinal())) {
            throw new IllegalArgumentException("Vertex '" + edge.getSourceName() + "' already has an outbound edge at ordinal " + edge.getSourceOrdinal() + (edge.getSourceOrdinal() == 0 && edge.getDestOrdinal() == 0 ? ", use Edge.from().to() to specify another ordinal" : ""));
        }
        if (edge.getSource() == edge.getDestination()) {
            throw new IllegalArgumentException("Attempted to add an edge from " + edge.getSourceName() + " to itself");
        }
        boolean success = this.edges.add(edge);
        assert (success) : "Duplicate edge added: " + edge;
        return this;
    }

    @Nonnull
    public List<Edge> getInboundEdges(@Nonnull String vertexName) {
        if (!this.nameToVertex.containsKey(vertexName)) {
            throw new IllegalArgumentException("No vertex with name '" + vertexName + "' found in this DAG");
        }
        ArrayList<Edge> inboundEdges = new ArrayList<Edge>();
        for (Edge edge : this.edges) {
            if (!edge.getDestName().equals(vertexName)) continue;
            inboundEdges.add(edge);
        }
        return inboundEdges;
    }

    @Nonnull
    public List<Edge> getOutboundEdges(@Nonnull String vertexName) {
        if (!this.nameToVertex.containsKey(vertexName)) {
            throw new IllegalArgumentException("No vertex with name '" + vertexName + "' found in this DAG");
        }
        ArrayList<Edge> outboundEdges = new ArrayList<Edge>();
        for (Edge edge : this.edges) {
            if (!edge.getSourceName().equals(vertexName)) continue;
            outboundEdges.add(edge);
        }
        return outboundEdges;
    }

    @Nullable
    public Vertex getVertex(@Nonnull String vertexName) {
        return this.nameToVertex.get(vertexName);
    }

    @Override
    @Nonnull
    public Iterator<Vertex> iterator() {
        return this.validate().iterator();
    }

    private String uniqueName(String namePrefix) {
        String name = namePrefix;
        int i = 2;
        while (this.nameToVertex.containsKey(name)) {
            name = namePrefix + '-' + i;
            ++i;
        }
        return name;
    }

    private Vertex addVertex(Vertex vertex) {
        if (this.nameToVertex.containsKey(vertex.getName())) {
            throw new IllegalArgumentException("Vertex " + vertex.getName() + " is already defined.");
        }
        this.verticesByIdentity.add(vertex);
        this.nameToVertex.put(vertex.getName(), vertex);
        return vertex;
    }

    private boolean containsVertex(Vertex vertex) {
        return this.verticesByIdentity.contains(vertex);
    }

    private boolean containsVertexName(Vertex vertex) {
        return this.nameToVertex.containsKey(vertex.getName());
    }

    Iterable<Vertex> validate() {
        Preconditions.checkTrue((!this.nameToVertex.isEmpty() ? 1 : 0) != 0, (String)"DAG must contain at least one vertex");
        Map<String, List<Edge>> inboundEdgeMap = this.edges.stream().collect(Collectors.groupingBy(Edge::getDestName));
        Map<String, List<Edge>> outboundEdgeMap = this.edges.stream().collect(Collectors.groupingBy(Edge::getSourceName));
        DAG.validateInboundEdgeOrdinals(inboundEdgeMap);
        DAG.validateOutboundEdgeOrdinals(outboundEdgeMap);
        HashMap adjacencyMap = new HashMap();
        for (Edge edge : this.edges) {
            adjacencyMap.computeIfAbsent(edge.getSource(), x -> new ArrayList()).add(edge.getDestination());
        }
        for (Vertex v : this.nameToVertex.values()) {
            adjacencyMap.putIfAbsent(v, Collections.emptyList());
        }
        return TopologicalSorter.topologicalSort(adjacencyMap, Vertex::getName);
    }

    private static void validateInboundEdgeOrdinals(Map<String, List<Edge>> inboundEdgeMap) {
        for (Map.Entry<String, List<Edge>> entry : inboundEdgeMap.entrySet()) {
            String vertex = entry.getKey();
            int[] ordinals = entry.getValue().stream().mapToInt(Edge::getDestOrdinal).sorted().toArray();
            for (int i = 0; i < ordinals.length; ++i) {
                if (ordinals[i] == i) continue;
                throw new IllegalArgumentException("Input ordinals for vertex " + vertex + " are not properly numbered. Actual: " + Arrays.toString(ordinals) + " Expected: " + Arrays.toString(IntStream.range(0, ordinals.length).toArray()));
            }
        }
    }

    private static void validateOutboundEdgeOrdinals(Map<String, List<Edge>> outboundEdgeMap) {
        for (Map.Entry<String, List<Edge>> entry : outboundEdgeMap.entrySet()) {
            String vertex = entry.getKey();
            int[] ordinals = entry.getValue().stream().mapToInt(Edge::getSourceOrdinal).sorted().toArray();
            for (int i = 0; i < ordinals.length; ++i) {
                if (ordinals[i] == i) continue;
                throw new IllegalArgumentException("Output ordinals for vertex " + vertex + " are not ordered. Actual: " + Arrays.toString(ordinals) + " Expected: " + Arrays.toString(IntStream.range(0, ordinals.length).toArray()));
            }
        }
    }

    @Nonnull
    public String toString() {
        return this.toString(-1);
    }

    @Nonnull
    public String toString(int defaultLocalParallelism) {
        StringBuilder b = new StringBuilder("dag\n");
        for (Vertex v : this) {
            b.append("    .vertex(\"").append(v.getName()).append("\")");
            int localParallelism = v.determineLocalParallelism(defaultLocalParallelism);
            if (localParallelism != -1) {
                b.append(".localParallelism(").append(localParallelism).append(')');
            }
            b.append('\n');
        }
        for (Edge e : this.edges) {
            b.append("    .edge(").append(e).append(")\n");
        }
        return b.toString();
    }

    @Nonnull
    public JsonObject toJson(int defaultLocalParallelism) {
        JsonObject dag = new JsonObject();
        JsonArray vertices = new JsonArray();
        for (Vertex v : this) {
            JsonObject vertex = new JsonObject();
            vertex.add("name", v.getName());
            vertex.add("parallelism", v.determineLocalParallelism(defaultLocalParallelism));
            vertices.add((JsonValue)vertex);
        }
        dag.add("vertices", (JsonValue)vertices);
        JsonArray edges = new JsonArray();
        for (Edge e : this.edges) {
            JsonObject edge = new JsonObject();
            edge.add("from", e.getSourceName());
            edge.add("fromOrdinal", e.getSourceOrdinal());
            edge.add("to", e.getDestName());
            edge.add("toOrdinal", e.getDestOrdinal());
            edge.add("priority", e.getPriority());
            edge.add("distributedTo", String.valueOf(e.getDistributedTo()));
            edge.add("type", e.getRoutingPolicy().toString().toLowerCase());
            edges.add((JsonValue)edge);
        }
        dag.add("edges", (JsonValue)edges);
        return dag;
    }

    @Nonnull
    public String toDotString() {
        return this.toDotString(-1);
    }

    @Nonnull
    public String toDotString(int defaultParallelism) {
        StringBuilder builder = new StringBuilder(512);
        builder.append("digraph DAG {\n");
        int clusterCount = 0;
        for (Vertex v2 : this) {
            int localParallelism = v2.determineLocalParallelism(defaultParallelism);
            String parallelism = localParallelism == -1 ? (defaultParallelism == -1 ? "default" : String.valueOf(defaultParallelism)) : String.valueOf(localParallelism);
            builder.append("\t\"").append(Util.escapeGraphviz(v2.getName())).append("\" [localParallelism=").append(parallelism).append("]").append(";\n");
        }
        HashMap<String, int[]> inOutCounts = new HashMap<String, int[]>();
        for (Edge edge : this.edges) {
            int[] nArray = inOutCounts.computeIfAbsent(edge.getSourceName(), v -> new int[2]);
            nArray[0] = nArray[0] + 1;
            int[] nArray2 = inOutCounts.computeIfAbsent(edge.getDestName(), v -> new int[2]);
            nArray2[1] = nArray2[1] + 1;
        }
        for (Vertex v3 : this) {
            List<Edge> out = this.getOutboundEdges(v3.getName());
            for (Edge e : out) {
                ArrayList<String> attributes = new ArrayList<String>();
                String edgeLabel = this.getEdgeLabel(e);
                if (!StringUtil.isNullOrEmpty((String)edgeLabel)) {
                    attributes.add("label=\"" + edgeLabel + "\"");
                }
                if (((int[])inOutCounts.get(e.getDestName()))[1] > 1) {
                    attributes.add("headlabel=" + e.getDestOrdinal());
                }
                if (((int[])inOutCounts.get(e.getSourceName()))[0] > 1) {
                    attributes.add("taillabel=" + e.getSourceOrdinal());
                }
                int queueSize = e.getConfig() == null ? 1024 : e.getConfig().getQueueSize();
                attributes.add("queueSize=" + queueSize);
                boolean inSubgraph = e.getSourceName().equals(e.getDestName() + "-prepare");
                if (inSubgraph) {
                    builder.append("\tsubgraph cluster_").append(clusterCount++).append(" {\n").append("\t");
                }
                String source = Util.escapeGraphviz(e.getSourceName());
                String destination = Util.escapeGraphviz(e.getDestName());
                builder.append("\t").append("\"").append(source).append("\"").append(" -> ").append("\"").append(destination).append("\"");
                if (attributes.size() > 0) {
                    builder.append(attributes.stream().collect(Collectors.joining(", ", " [", "]")));
                }
                builder.append(";\n");
                if (!inSubgraph) continue;
                builder.append("\t}\n");
            }
        }
        builder.append("}");
        return builder.toString();
    }

    private String getEdgeLabel(Edge e) {
        ArrayList<String> labels = new ArrayList<String>();
        if (Edge.DISTRIBUTE_TO_ALL.equals((Object)e.getDistributedTo())) {
            labels.add("distributed");
        } else if (e.getDistributedTo() != null) {
            labels.add("distributed to " + e.getDistributedTo());
        }
        if (e.getRoutingPolicy() != Edge.RoutingPolicy.UNICAST) {
            labels.add(e.getRoutingPolicy().toString().toLowerCase());
        }
        return String.join((CharSequence)"-", labels);
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.nameToVertex.size());
        for (Map.Entry<String, Vertex> entry : this.nameToVertex.entrySet()) {
            out.writeObject((Object)entry.getKey());
            out.writeObject((Object)entry.getValue());
        }
        out.writeInt(this.edges.size());
        for (Edge edge : this.edges) {
            out.writeObject((Object)edge);
        }
    }

    public void readData(ObjectDataInput in) throws IOException {
        int vertexCount = in.readInt();
        for (int i = 0; i < vertexCount; ++i) {
            String key = (String)in.readObject();
            Vertex value = (Vertex)in.readObject();
            this.nameToVertex.put(key, value);
        }
        int edgeCount = in.readInt();
        for (int i = 0; i < edgeCount; ++i) {
            Edge edge = (Edge)in.readObject();
            edge.restoreSourceAndDest(this.nameToVertex);
            this.edges.add(edge);
        }
        this.verticesByIdentity.addAll(this.nameToVertex.values());
    }

    public int getFactoryId() {
        return JetDataSerializerHook.FACTORY_ID;
    }

    public int getClassId() {
        return 0;
    }
}

