/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.pipeline;

import com.hazelcast.function.BiConsumerEx;
import com.hazelcast.function.ConsumerEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.core.processor.SinkProcessors;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.pipeline.Sink;
import com.hazelcast.jet.pipeline.Sinks;
import javax.annotation.Nonnull;

public final class SinkBuilder<C, T> {
    private final FunctionEx<? super Processor.Context, ? extends C> createFn;
    private final String name;
    private BiConsumerEx<? super C, ? super T> receiveFn;
    private ConsumerEx<? super C> flushFn = ConsumerEx.noop();
    private ConsumerEx<? super C> destroyFn = ConsumerEx.noop();
    private int preferredLocalParallelism = 1;

    private SinkBuilder(@Nonnull String name, @Nonnull FunctionEx<? super Processor.Context, ? extends C> createFn) {
        Util.checkSerializable(createFn, "createFn");
        this.name = name;
        this.createFn = createFn;
    }

    @Nonnull
    public static <C> SinkBuilder<C, Void> sinkBuilder(@Nonnull String name, @Nonnull FunctionEx<Processor.Context, ? extends C> createFn) {
        return new SinkBuilder(name, createFn);
    }

    @Nonnull
    public <T_NEW> SinkBuilder<C, T_NEW> receiveFn(@Nonnull BiConsumerEx<? super C, ? super T_NEW> receiveFn) {
        Util.checkSerializable(receiveFn, "receiveFn");
        SinkBuilder newThis = this;
        newThis.receiveFn = receiveFn;
        return newThis;
    }

    @Nonnull
    public SinkBuilder<C, T> flushFn(@Nonnull ConsumerEx<? super C> flushFn) {
        Util.checkSerializable(flushFn, "flushFn");
        this.flushFn = flushFn;
        return this;
    }

    @Nonnull
    public SinkBuilder<C, T> destroyFn(@Nonnull ConsumerEx<? super C> destroyFn) {
        Util.checkSerializable(destroyFn, "destroyFn");
        this.destroyFn = destroyFn;
        return this;
    }

    @Nonnull
    public SinkBuilder<C, T> preferredLocalParallelism(int preferredLocalParallelism) {
        Vertex.checkLocalParallelism(preferredLocalParallelism);
        this.preferredLocalParallelism = preferredLocalParallelism;
        return this;
    }

    @Nonnull
    public Sink<T> build() {
        Preconditions.checkNotNull(this.receiveFn, (String)"receiveFn must be set");
        SupplierEx<Processor> supplier = SinkProcessors.writeBufferedP(this.createFn, this.receiveFn, this.flushFn, this.destroyFn);
        return Sinks.fromProcessor(this.name, ProcessorMetaSupplier.of(this.preferredLocalParallelism, supplier));
    }
}

