/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.json;

import com.fasterxml.jackson.jr.annotationsupport.JacksonAnnotationExtension;
import com.fasterxml.jackson.jr.ob.JSON;
import com.fasterxml.jackson.jr.ob.JacksonJrExtension;
import com.hazelcast.core.HazelcastJsonValue;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class JsonUtil {
    private static final JSON JSON_JR;

    private JsonUtil() {
    }

    @Nonnull
    public static HazelcastJsonValue hazelcastJsonValue(@Nonnull Object object) {
        return new HazelcastJsonValue(object.toString());
    }

    @Nullable
    public static <T> T beanFrom(@Nonnull String jsonString, @Nonnull Class<T> type) throws IOException {
        return (T)JSON_JR.beanFrom(type, (Object)jsonString);
    }

    @Nullable
    public static Map<String, Object> mapFrom(@Nonnull String jsonString) throws IOException {
        return JSON_JR.mapFrom((Object)jsonString);
    }

    @Nullable
    public static <T> List<T> listFrom(@Nonnull String jsonString, @Nonnull Class<T> type) throws IOException {
        return JSON_JR.listOfFrom(type, (Object)jsonString);
    }

    @Nullable
    public static List<Object> listFrom(@Nonnull String jsonString) throws IOException {
        return JSON_JR.listFrom((Object)jsonString);
    }

    @Nullable
    public static Object anyFrom(@Nonnull String jsonString) throws IOException {
        return JSON_JR.anyFrom((Object)jsonString);
    }

    @Nonnull
    public static <T> Iterator<T> beanSequenceFrom(@Nonnull Reader reader, @Nonnull Class<T> type) throws IOException {
        return JSON_JR.beanSequenceFrom(type, (Object)reader);
    }

    @Nonnull
    public static Iterator<Map<String, Object>> mapSequenceFrom(@Nonnull Reader reader) throws IOException {
        return JSON_JR.anySequenceFrom((Object)reader);
    }

    @Nonnull
    public static <T> Stream<T> beanSequenceFrom(Path path, @Nonnull Class<T> type) throws IOException {
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(path.toFile()), StandardCharsets.UTF_8);
        Spliterator<T> spliterator = Spliterators.spliteratorUnknownSize(JsonUtil.beanSequenceFrom(reader, type), 272);
        return StreamSupport.stream(spliterator, false);
    }

    @Nonnull
    public static Stream<Map<String, Object>> mapSequenceFrom(Path path) throws IOException {
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(path.toFile()), StandardCharsets.UTF_8);
        Spliterator<Map<String, Object>> spliterator = Spliterators.spliteratorUnknownSize(JsonUtil.mapSequenceFrom(reader), 272);
        return StreamSupport.stream(spliterator, false);
    }

    @Nonnull
    public static String toJson(@Nonnull Object object) throws IOException {
        return JSON_JR.asString(object);
    }

    static {
        JSON.Builder builder = JSON.builder();
        try {
            Class.forName("com.fasterxml.jackson.annotation.JacksonAnnotation", false, JsonUtil.class.getClassLoader());
            builder.register((JacksonJrExtension)JacksonAnnotationExtension.std);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        JSON_JR = builder.build();
    }
}

