/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.execution.init;

import com.hazelcast.cluster.Address;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

class PartitionArrangement {
    private final Map<Address, int[]> remotePartitionAssignment;
    private final int[] allPartitions;
    private final int[] localPartitions;

    PartitionArrangement(Address[] partitionOwners, Address thisAddress) {
        this.localPartitions = IntStream.range(0, partitionOwners.length).filter(partitionId -> thisAddress.equals((Object)partitionOwners[partitionId])).toArray();
        this.allPartitions = IntStream.range(0, partitionOwners.length).toArray();
        this.remotePartitionAssignment = IntStream.range(0, partitionOwners.length).filter(partitionId -> !thisAddress.equals((Object)partitionOwners[partitionId])).boxed().collect(Collectors.groupingBy(partitionId -> partitionOwners[partitionId], Collectors.collectingAndThen(Collectors.toList(), l -> l.stream().mapToInt(i -> i).toArray())));
    }

    Map<Address, int[]> getRemotePartitionAssignment() {
        return this.remotePartitionAssignment;
    }

    int[][] assignPartitionsToProcessors(int localParallelism, boolean isEdgeDistributed) {
        int[] ptions = isEdgeDistributed ? this.localPartitions : this.allPartitions;
        int[][] ptionsPerProcessor = PartitionArrangement.createPtionArrays(ptions.length, localParallelism);
        for (int i = 0; i < localParallelism; ++i) {
            int j = 0;
            int ptionIndex = i;
            while (ptionIndex < ptions.length) {
                ptionsPerProcessor[i][j] = ptions[ptionIndex];
                ptionIndex += localParallelism;
                ++j;
            }
        }
        return ptionsPerProcessor;
    }

    private static int[][] createPtionArrays(int ptionCount, int processorCount) {
        int[][] ptionsPerProcessor = new int[processorCount][];
        int quot = ptionCount / processorCount;
        int rem = ptionCount % processorCount;
        Arrays.setAll(ptionsPerProcessor, i -> new int[quot + (i < rem ? 1 : 0)]);
        return ptionsPerProcessor;
    }

    public Map<Address, int[]> remotePartitionAssignmentToOne(Address target) {
        HashMap<Address, int[]> res = new HashMap<Address, int[]>();
        for (Address address : this.remotePartitionAssignment.keySet()) {
            res.put(address, address.equals((Object)target) ? this.allPartitions : new int[]{});
        }
        return res;
    }
}

