/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.connector;

import com.hazelcast.cache.ICache;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.cluster.Address;
import com.hazelcast.collection.IList;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.function.BiConsumerEx;
import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.function.BinaryOperatorEx;
import com.hazelcast.function.ConsumerEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.jet.RestartableException;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.impl.connector.AbstractHazelcastConnectorSupplier;
import com.hazelcast.jet.impl.connector.UpdateMapP;
import com.hazelcast.jet.impl.connector.UpdateMapWithEntryProcessorP;
import com.hazelcast.jet.impl.connector.WriteBufferedP;
import com.hazelcast.jet.impl.connector.WriteMapP;
import com.hazelcast.jet.impl.connector.WriteObservableP;
import com.hazelcast.jet.impl.observer.ObservableImpl;
import com.hazelcast.jet.impl.util.ImdgUtil;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.map.EntryProcessor;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class HazelcastWriters {
    private HazelcastWriters() {
    }

    @Nonnull
    public static <T, K, V> ProcessorMetaSupplier writeMapSupplier(@Nonnull String name, @Nullable ClientConfig clientConfig, @Nonnull FunctionEx<? super T, ? extends K> toKeyFn, @Nonnull FunctionEx<? super T, ? extends V> toValueFn) {
        return ProcessorMetaSupplier.preferLocalParallelismOne(new WriteMapP.Supplier<T, K, V>(ImdgUtil.asXmlString(clientConfig), name, toKeyFn, toValueFn));
    }

    @Nonnull
    public static <T, K, V> ProcessorMetaSupplier mergeMapSupplier(@Nonnull String name, @Nullable ClientConfig clientConfig, @Nonnull FunctionEx<? super T, ? extends K> toKeyFn, @Nonnull FunctionEx<? super T, ? extends V> toValueFn, @Nonnull BinaryOperatorEx<V> mergeFn) {
        Util.checkSerializable(toKeyFn, "toKeyFn");
        Util.checkSerializable(toValueFn, "toValueFn");
        Util.checkSerializable(mergeFn, "mergeFn");
        return HazelcastWriters.updateMapSupplier(name, clientConfig, toKeyFn, (BiFunctionEx & Serializable)(oldValue, item) -> {
            Object newValue = toValueFn.apply(item);
            if (oldValue == null) {
                return newValue;
            }
            return mergeFn.apply(oldValue, newValue);
        });
    }

    @Nonnull
    public static <T, K, V> ProcessorMetaSupplier updateMapSupplier(@Nonnull String mapName, @Nullable ClientConfig clientConfig, @Nonnull FunctionEx<? super T, ? extends K> toKeyFn, @Nonnull BiFunctionEx<? super V, ? super T, ? extends V> updateFn) {
        Util.checkSerializable(toKeyFn, "toKeyFn");
        Util.checkSerializable(updateFn, "updateFn");
        return ProcessorMetaSupplier.of(AbstractHazelcastConnectorSupplier.of(ImdgUtil.asXmlString(clientConfig), (FunctionEx<HazelcastInstance, Processor>)(FunctionEx & Serializable)instance -> new UpdateMapP((HazelcastInstance)instance, mapName, toKeyFn, updateFn)));
    }

    @Nonnull
    public static <T, K, V, R> ProcessorMetaSupplier updateMapSupplier(@Nonnull String name, @Nullable ClientConfig clientConfig, @Nonnull FunctionEx<? super T, ? extends K> toKeyFn, @Nonnull FunctionEx<? super T, ? extends EntryProcessor<K, V, R>> toEntryProcessorFn) {
        Util.checkSerializable(toKeyFn, "toKeyFn");
        Util.checkSerializable(toEntryProcessorFn, "toEntryProcessorFn");
        return ProcessorMetaSupplier.of(AbstractHazelcastConnectorSupplier.of(ImdgUtil.asXmlString(clientConfig), (FunctionEx<HazelcastInstance, Processor>)(FunctionEx & Serializable)instance -> new UpdateMapWithEntryProcessorP((HazelcastInstance)instance, name, toKeyFn, toEntryProcessorFn)));
    }

    @Nonnull
    public static <T, K, V, R> ProcessorMetaSupplier updateMapSupplier(int maxParallelAsyncOps, @Nonnull String name, @Nullable ClientConfig clientConfig, @Nonnull FunctionEx<? super T, ? extends K> toKeyFn, @Nonnull FunctionEx<? super T, ? extends EntryProcessor<K, V, R>> toEntryProcessorFn) {
        Util.checkSerializable(toKeyFn, "toKeyFn");
        Util.checkSerializable(toEntryProcessorFn, "toEntryProcessorFn");
        return ProcessorMetaSupplier.of(AbstractHazelcastConnectorSupplier.of(ImdgUtil.asXmlString(clientConfig), (FunctionEx<HazelcastInstance, Processor>)(FunctionEx & Serializable)instance -> new UpdateMapWithEntryProcessorP((HazelcastInstance)instance, maxParallelAsyncOps, name, toKeyFn, toEntryProcessorFn)));
    }

    @Nonnull
    public static ProcessorMetaSupplier writeCacheSupplier(@Nonnull String name, @Nullable ClientConfig clientConfig) {
        return ProcessorMetaSupplier.of(2, new WriteCachePSupplier(clientConfig, name));
    }

    @Nonnull
    public static ProcessorMetaSupplier writeListSupplier(@Nonnull String name, @Nullable ClientConfig clientConfig) {
        return ProcessorMetaSupplier.preferLocalParallelismOne(new WriteListPSupplier(clientConfig, name));
    }

    public static ProcessorMetaSupplier writeObservableSupplier(final @Nonnull String name) {
        return new ProcessorMetaSupplier(){

            @Override
            @Nonnull
            public Map<String, String> getTags() {
                return Collections.singletonMap(ObservableImpl.OWNED_OBSERVABLE, name);
            }

            @Override
            public int preferredLocalParallelism() {
                return 1;
            }

            @Override
            @Nonnull
            public Function<? super Address, ? extends ProcessorSupplier> get(@Nonnull List<Address> addresses) {
                return address -> new WriteObservableP.Supplier(name);
            }
        };
    }

    static RuntimeException handleInstanceNotActive(HazelcastInstanceNotActiveException e, boolean isLocal) {
        return isLocal ? new RestartableException(e) : e;
    }

    static final class ArrayMap<K, V>
    extends AbstractMap<K, V> {
        private final List<Map.Entry<K, V>> entries;
        private final ArraySet set = new ArraySet();

        ArrayMap() {
            this.entries = new ArrayList<Map.Entry<K, V>>();
        }

        ArrayMap(int size) {
            this.entries = new ArrayList<Map.Entry<K, V>>(size);
        }

        @Override
        @Nonnull
        public Set<Map.Entry<K, V>> entrySet() {
            return this.set;
        }

        public void add(Map.Entry<K, V> entry) {
            this.entries.add(entry);
        }

        @Override
        public V get(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String toString() {
            return this.entries.toString();
        }

        private class ArraySet
        extends AbstractSet<Map.Entry<K, V>> {
            private ArraySet() {
            }

            @Override
            @Nonnull
            public Iterator<Map.Entry<K, V>> iterator() {
                return ArrayMap.this.entries.iterator();
            }

            @Override
            public int size() {
                return ArrayMap.this.entries.size();
            }

            @Override
            public void clear() {
                ArrayMap.this.entries.clear();
            }
        }
    }

    private static class WriteListPSupplier<T>
    extends AbstractHazelcastConnectorSupplier {
        static final long serialVersionUID = 1L;
        private final String name;

        WriteListPSupplier(@Nullable ClientConfig clientConfig, @Nonnull String name) {
            super(ImdgUtil.asXmlString(clientConfig));
            this.name = name;
        }

        @Override
        protected Processor createProcessor(HazelcastInstance instance, SerializationService serializationService) {
            IList list = instance.getList(this.name);
            FunctionEx & Serializable bufferCreator = (FunctionEx & Serializable)context -> new ArrayList();
            BiConsumerEx & Serializable itemReceiver = (BiConsumerEx & Serializable)(buffer, item) -> buffer.add(serializationService.toData(item));
            ConsumerEx & Serializable bufferFlusher = (ConsumerEx & Serializable)buffer -> {
                try {
                    list.addAll((Collection)buffer);
                }
                catch (HazelcastInstanceNotActiveException e) {
                    throw HazelcastWriters.handleInstanceNotActive(e, this.isLocal());
                }
                buffer.clear();
            };
            return new WriteBufferedP(bufferCreator, itemReceiver, bufferFlusher, ConsumerEx.noop());
        }
    }

    private static class WriteCachePSupplier<K, V>
    extends AbstractHazelcastConnectorSupplier {
        static final long serialVersionUID = 1L;
        private final String name;

        WriteCachePSupplier(@Nullable ClientConfig clientConfig, @Nonnull String name) {
            super(ImdgUtil.asXmlString(clientConfig));
            this.name = name;
        }

        @Override
        protected Processor createProcessor(HazelcastInstance instance, SerializationService serializationService) {
            ICache cache = instance.getCacheManager().getCache(this.name);
            FunctionEx & Serializable bufferCreator = (FunctionEx & Serializable)context -> new ArrayMap();
            BiConsumerEx & Serializable entryReceiver = (BiConsumerEx & Serializable)(buffer, entry) -> {
                Data key = serializationService.toData(entry.getKey());
                Data value = serializationService.toData(entry.getValue());
                buffer.add(new AbstractMap.SimpleEntry<Data, Data>(key, value));
            };
            ConsumerEx & Serializable bufferFlusher = (ConsumerEx & Serializable)buffer -> {
                try {
                    cache.putAll((Map)buffer);
                }
                catch (HazelcastInstanceNotActiveException e) {
                    throw HazelcastWriters.handleInstanceNotActive(e, this.isLocal());
                }
                buffer.clear();
            };
            return new WriteBufferedP(bufferCreator, entryReceiver, bufferFlusher, ConsumerEx.noop());
        }
    }
}

