/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.retry.impl;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.jet.retry.IntervalFunction;
import java.io.Serializable;

public final class IntervalFunctions {
    private IntervalFunctions() {
    }

    public static IntervalFunction constant(long intervalMillis) {
        IntervalFunctions.checkInterval(intervalMillis);
        return new IntervalFunctionImpl((FunctionEx<Integer, Long>)(FunctionEx & Serializable)attempt -> intervalMillis, "constant of " + intervalMillis + "ms");
    }

    public static IntervalFunction exponentialBackoff(long intervalMillis, double multiplier) {
        IntervalFunctions.checkInterval(intervalMillis);
        IntervalFunctions.checkMultiplier(multiplier);
        return new IntervalFunctionImpl((FunctionEx<Integer, Long>)(FunctionEx & Serializable)attempt -> (long)((double)intervalMillis * Math.pow(multiplier, attempt - 1)), "exponential backoff from " + intervalMillis + "ms by a factor of " + multiplier);
    }

    private static void checkInterval(long interval) {
        if (interval < 1L) {
            throw new IllegalArgumentException("Illegal argument interval: " + interval + " millis is less than 1");
        }
    }

    private static void checkAttempt(Integer attempt) {
        if (attempt < 1) {
            throw new IllegalArgumentException("Illegal attempt argument: " + attempt);
        }
    }

    private static void checkMultiplier(double multiplier) {
        if (multiplier < 1.0) {
            throw new IllegalArgumentException("Illegal argument multiplier: " + multiplier);
        }
    }

    private static class IntervalFunctionImpl
    implements IntervalFunction {
        private final FunctionEx<Integer, Long> fn;
        private final String description;

        IntervalFunctionImpl(FunctionEx<Integer, Long> fn, String description) {
            this.fn = fn;
            this.description = description;
        }

        @Override
        public long waitAfterAttempt(int attempt) {
            IntervalFunctions.checkAttempt(attempt);
            return (Long)this.fn.apply((Object)attempt);
        }

        public String toString() {
            return IntervalFunction.class.getSimpleName() + " (" + this.description + ")";
        }
    }
}

