/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.json;

import com.fasterxml.jackson.jr.ob.impl.DeferredMap;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Serializer;
import com.hazelcast.nio.serialization.SerializerHook;
import com.hazelcast.nio.serialization.StreamSerializer;
import java.io.IOException;
import java.util.Map;

class JsonSerializerHooks {
    JsonSerializerHooks() {
    }

    public static final class DeferredMapHook
    implements SerializerHook<DeferredMap> {
        public Class<DeferredMap> getSerializationType() {
            return DeferredMap.class;
        }

        public Serializer createSerializer() {
            return new StreamSerializer<DeferredMap>(){

                public int getTypeId() {
                    return -327;
                }

                public void write(ObjectDataOutput out, DeferredMap deferredMap) throws IOException {
                    out.writeInt(deferredMap.size());
                    for (Map.Entry entry : deferredMap.entrySet()) {
                        out.writeUTF((String)entry.getKey());
                        out.writeObject(entry.getValue());
                    }
                }

                public DeferredMap read(ObjectDataInput in) throws IOException {
                    int size = in.readInt();
                    DeferredMap deferredMap = new DeferredMap(false, size);
                    for (int i = 0; i < size; ++i) {
                        deferredMap.put(in.readUTF(), in.readObject());
                    }
                    return deferredMap;
                }
            };
        }

        public boolean isOverwritable() {
            return false;
        }
    }
}

