/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.cluster.ClusterState;
import com.hazelcast.instance.impl.DefaultNodeExtension;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Packet;
import com.hazelcast.jet.config.JetConfig;
import com.hazelcast.jet.impl.JetService;
import com.hazelcast.jet.impl.NodeExtensionCommon;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.util.Map;

public class JetNodeExtension
extends DefaultNodeExtension
implements NodeEngineImpl.JetPacketConsumer {
    private final NodeExtensionCommon extCommon;

    public JetNodeExtension(Node node) {
        super(node);
        this.extCommon = new NodeExtensionCommon(node, new JetService(node));
    }

    public void beforeStart() {
        JetConfig config = JetService.findJetServiceConfig(this.node.getConfig());
        if (config.getInstanceConfig().isLosslessRestartEnabled()) {
            throw new UnsupportedOperationException("Lossless Restart is not available in the open-source version of Hazelcast Jet");
        }
        super.beforeStart();
    }

    public void afterStart() {
        super.afterStart();
        this.extCommon.afterStart();
    }

    public void beforeClusterStateChange(ClusterState currState, ClusterState requestedState, boolean isTransient) {
        super.beforeClusterStateChange(currState, requestedState, isTransient);
        this.extCommon.beforeClusterStateChange(requestedState);
    }

    public void onClusterStateChange(ClusterState newState, boolean isTransient) {
        super.onClusterStateChange(newState, isTransient);
        this.extCommon.onClusterStateChange(newState);
    }

    public Map<String, Object> createExtensionServices() {
        return this.extCommon.createExtensionServices();
    }

    public void printNodeInfo() {
        this.extCommon.printNodeInfo(this.systemLogger, "");
    }

    public void accept(Packet packet) {
        this.extCommon.handlePacket(packet);
    }
}

