/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.aggregate;

import com.hazelcast.aggregation.Aggregator;
import com.hazelcast.function.BiConsumerEx;
import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.function.BinaryOperatorEx;
import com.hazelcast.function.ComparatorEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.PredicateEx;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.function.ToDoubleFunctionEx;
import com.hazelcast.function.ToLongFunctionEx;
import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.accumulator.DoubleAccumulator;
import com.hazelcast.jet.accumulator.LinTrendAccumulator;
import com.hazelcast.jet.accumulator.LongAccumulator;
import com.hazelcast.jet.accumulator.LongDoubleAccumulator;
import com.hazelcast.jet.accumulator.LongLongAccumulator;
import com.hazelcast.jet.accumulator.MutableReference;
import com.hazelcast.jet.aggregate.AggregateOperation;
import com.hazelcast.jet.aggregate.AggregateOperation1;
import com.hazelcast.jet.aggregate.AggregateOperation2;
import com.hazelcast.jet.aggregate.AggregateOperation3;
import com.hazelcast.jet.aggregate.AllOfAggregationBuilder;
import com.hazelcast.jet.aggregate.CoAggregateOperationBuilder;
import com.hazelcast.jet.datamodel.Tuple2;
import com.hazelcast.jet.datamodel.Tuple3;
import com.hazelcast.jet.function.TriFunction;
import com.hazelcast.jet.impl.aggregate.AggregateOpAggregator;
import com.hazelcast.jet.impl.util.Util;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class AggregateOperations {
    private AggregateOperations() {
    }

    @Nonnull
    public static <T> AggregateOperation1<T, LongAccumulator, Long> counting() {
        return AggregateOperation.withCreate(LongAccumulator::new).andAccumulate((BiConsumerEx & Serializable)(a, item) -> a.add(1L)).andCombine(LongAccumulator::add).andDeduct(LongAccumulator::subtractAllowingOverflow).andExportFinish(LongAccumulator::get);
    }

    @Nonnull
    public static <T> AggregateOperation1<T, LongAccumulator, Long> summingLong(@Nonnull ToLongFunctionEx<? super T> getLongValueFn) {
        Util.checkSerializable(getLongValueFn, "getLongValueFn");
        return AggregateOperation.withCreate(LongAccumulator::new).andAccumulate((BiConsumerEx & Serializable)(a, item) -> a.add(getLongValueFn.applyAsLong(item))).andCombine(LongAccumulator::add).andDeduct(LongAccumulator::subtract).andExportFinish(LongAccumulator::get);
    }

    @Nonnull
    public static <T> AggregateOperation1<T, DoubleAccumulator, Double> summingDouble(@Nonnull ToDoubleFunctionEx<? super T> getDoubleValueFn) {
        Util.checkSerializable(getDoubleValueFn, "getDoubleValueFn");
        return AggregateOperation.withCreate(DoubleAccumulator::new).andAccumulate((BiConsumerEx & Serializable)(a, item) -> a.accumulate(getDoubleValueFn.applyAsDouble(item))).andCombine(DoubleAccumulator::combine).andDeduct(DoubleAccumulator::deduct).andExportFinish(DoubleAccumulator::export);
    }

    @Nonnull
    public static <T> AggregateOperation1<T, MutableReference<T>, T> minBy(@Nonnull ComparatorEx<? super T> comparator) {
        Util.checkSerializable(comparator, "comparator");
        return AggregateOperations.maxBy(comparator.reversed());
    }

    @Nonnull
    public static <T> AggregateOperation1<T, MutableReference<T>, T> maxBy(@Nonnull ComparatorEx<? super T> comparator) {
        Util.checkSerializable(comparator, "comparator");
        return AggregateOperation.withCreate(MutableReference::new).andAccumulate((BiConsumerEx & Serializable)(a, i) -> {
            if (a.isNull() || comparator.compare(i, a.get()) > 0) {
                a.set(i);
            }
        }).andCombine((BiConsumerEx & Serializable)(a1, a2) -> {
            if (a1.isNull() || comparator.compare(a1.get(), a2.get()) < 0) {
                a1.set(a2.get());
            }
        }).andExportFinish(MutableReference::get);
    }

    @Nonnull
    public static <T> AggregateOperation1<T, PriorityQueue<T>, List<T>> topN(int n, @Nonnull ComparatorEx<? super T> comparator) {
        Util.checkSerializable(comparator, "comparator");
        ComparatorEx comparatorReversed = comparator.reversed();
        BiConsumerEx & Serializable accumulateFn = (BiConsumerEx & Serializable)(queue, item) -> {
            if (queue.size() == n) {
                if (comparator.compare(item, queue.peek()) <= 0) {
                    return;
                }
                queue.poll();
            }
            queue.offer(item);
        };
        return AggregateOperation.withCreate((SupplierEx & Serializable)() -> new PriorityQueue(n, comparator)).andAccumulate(accumulateFn).andCombine((BiConsumerEx & Serializable)(left, right) -> {
            for (Object item : right) {
                accumulateFn.accept(left, item);
            }
        }).andExportFinish((FunctionEx & Serializable)queue -> {
            ArrayList res = new ArrayList(queue);
            res.sort(comparatorReversed);
            return res;
        });
    }

    @Nonnull
    public static <T> AggregateOperation1<T, PriorityQueue<T>, List<T>> bottomN(int n, @Nonnull ComparatorEx<? super T> comparator) {
        return AggregateOperations.topN(n, comparator.reversed());
    }

    @Nonnull
    public static <T> AggregateOperation1<T, LongLongAccumulator, Double> averagingLong(@Nonnull ToLongFunctionEx<? super T> getLongValueFn) {
        Util.checkSerializable(getLongValueFn, "getLongValueFn");
        return AggregateOperation.withCreate(LongLongAccumulator::new).andAccumulate((BiConsumerEx & Serializable)(a, i) -> {
            if (a.get1() == Long.MAX_VALUE) {
                throw new ArithmeticException("Counter overflow");
            }
            a.set1(a.get1() + 1L);
            a.set2(Math.addExact(a.get2(), getLongValueFn.applyAsLong(i)));
        }).andCombine((BiConsumerEx & Serializable)(a1, a2) -> {
            a1.set1(Math.addExact(a1.get1(), a2.get1()));
            a1.set2(Math.addExact(a1.get2(), a2.get2()));
        }).andDeduct((BiConsumerEx & Serializable)(a1, a2) -> {
            a1.set1(Math.subtractExact(a1.get1(), a2.get1()));
            a1.set2(Math.subtractExact(a1.get2(), a2.get2()));
        }).andExportFinish((FunctionEx & Serializable)a -> (double)a.get2() / (double)a.get1());
    }

    @Nonnull
    public static <T> AggregateOperation1<T, LongDoubleAccumulator, Double> averagingDouble(@Nonnull ToDoubleFunctionEx<? super T> getDoubleValueFn) {
        Util.checkSerializable(getDoubleValueFn, "getDoubleValueFn");
        return AggregateOperation.withCreate(LongDoubleAccumulator::new).andAccumulate((BiConsumerEx & Serializable)(a, item) -> {
            if (a.getLong() == Long.MAX_VALUE) {
                throw new ArithmeticException("Counter overflow");
            }
            a.setLong(a.getLong() + 1L);
            a.setDouble(a.getDouble() + getDoubleValueFn.applyAsDouble(item));
        }).andCombine((BiConsumerEx & Serializable)(a1, a2) -> {
            a1.setLong(Math.addExact(a1.getLong(), a2.getLong()));
            a1.setDouble(a1.getDouble() + a2.getDouble());
        }).andDeduct((BiConsumerEx & Serializable)(a1, a2) -> {
            a1.setLong(Math.subtractExact(a1.getLong(), a2.getLong()));
            a1.setDouble(a1.getDouble() - a2.getDouble());
        }).andExportFinish((FunctionEx & Serializable)a -> a.getDouble() / (double)a.getLong());
    }

    @Nonnull
    public static <T> AggregateOperation1<T, LinTrendAccumulator, Double> linearTrend(@Nonnull ToLongFunctionEx<T> getXFn, @Nonnull ToLongFunctionEx<T> getYFn) {
        Util.checkSerializable(getXFn, "getXFn");
        Util.checkSerializable(getYFn, "getYFn");
        return AggregateOperation.withCreate(LinTrendAccumulator::new).andAccumulate((BiConsumerEx & Serializable)(a, item) -> a.accumulate(getXFn.applyAsLong(item), getYFn.applyAsLong(item))).andCombine(LinTrendAccumulator::combine).andDeduct(LinTrendAccumulator::deduct).andExportFinish(LinTrendAccumulator::export);
    }

    public static AggregateOperation1<CharSequence, StringBuilder, String> concatenating() {
        return AggregateOperation.withCreate(StringBuilder::new).andAccumulate(StringBuilder::append).andCombine(StringBuilder::append).andExportFinish(StringBuilder::toString);
    }

    public static AggregateOperation1<CharSequence, StringBuilder, String> concatenating(CharSequence delimiter) {
        return AggregateOperations.concatenating(delimiter, "", "");
    }

    public static AggregateOperation1<CharSequence, StringBuilder, String> concatenating(CharSequence delimiter, CharSequence prefix, CharSequence suffix) {
        int prefixLen = prefix.length();
        return AggregateOperation.withCreate((SupplierEx & Serializable)() -> new StringBuilder().append(prefix)).andAccumulate((BiConsumerEx & Serializable)(builder, val) -> {
            if (builder.length() != prefixLen && val.length() > 0) {
                builder.append(delimiter);
            }
            builder.append((CharSequence)val);
        }).andCombine((BiConsumerEx & Serializable)(l, r) -> {
            if (l.length() != prefixLen && r.length() != prefixLen) {
                l.append(delimiter);
            }
            l.append((CharSequence)r, prefixLen, r.length());
        }).andExportFinish((FunctionEx & Serializable)r -> {
            try {
                String string = r.append(suffix).toString();
                return string;
            }
            finally {
                r.setLength(r.length() - suffix.length());
            }
        });
    }

    public static <T, U, A, R> AggregateOperation1<T, A, R> mapping(@Nonnull FunctionEx<? super T, ? extends U> mapFn, @Nonnull AggregateOperation1<? super U, A, ? extends R> downstream) {
        Util.checkSerializable(mapFn, "mapFn");
        BiConsumerEx downstreamAccumulateFn = downstream.accumulateFn();
        return AggregateOperation.withCreate(downstream.createFn()).andAccumulate((BiConsumerEx & Serializable)(a, t) -> {
            Object mapped = mapFn.apply(t);
            if (mapped != null) {
                downstreamAccumulateFn.accept(a, mapped);
            }
        }).andCombine(downstream.combineFn()).andDeduct(downstream.deductFn()).andExport(downstream.exportFn()).andFinish(downstream.finishFn());
    }

    public static <T, A, R> AggregateOperation1<T, A, R> filtering(@Nonnull PredicateEx<? super T> filterFn, @Nonnull AggregateOperation1<? super T, A, ? extends R> downstream) {
        Util.checkSerializable(filterFn, "filterFn");
        BiConsumerEx downstreamAccumulateFn = downstream.accumulateFn();
        return AggregateOperation.withCreate(downstream.createFn()).andAccumulate((BiConsumerEx & Serializable)(a, t) -> {
            if (filterFn.test(t)) {
                downstreamAccumulateFn.accept(a, t);
            }
        }).andCombine(downstream.combineFn()).andDeduct(downstream.deductFn()).andExport(downstream.exportFn()).andFinish(downstream.finishFn());
    }

    public static <T, U, A, R> AggregateOperation1<T, A, R> flatMapping(@Nonnull FunctionEx<? super T, ? extends Traverser<? extends U>> flatMapFn, @Nonnull AggregateOperation1<? super U, A, ? extends R> downstream) {
        Util.checkSerializable(flatMapFn, "flatMapFn");
        BiConsumerEx downstreamAccumulateFn = downstream.accumulateFn();
        return AggregateOperation.withCreate(downstream.createFn()).andAccumulate((BiConsumerEx & Serializable)(a, t) -> {
            Object u;
            Traverser trav = (Traverser)flatMapFn.apply(t);
            while ((u = trav.next()) != null) {
                downstreamAccumulateFn.accept(a, u);
            }
        }).andCombine(downstream.combineFn()).andDeduct(downstream.deductFn()).andExport(downstream.exportFn()).andFinish(downstream.finishFn());
    }

    public static <T, C extends Collection<T>> AggregateOperation1<T, C, C> toCollection(@Nonnull SupplierEx<C> createCollectionFn) {
        Util.checkSerializable(createCollectionFn, "createCollectionFn");
        return AggregateOperation.withCreate(createCollectionFn).andAccumulate(Collection::add).andCombine(Collection::addAll).andExport((FunctionEx & Serializable)acc -> {
            Collection result = (Collection)createCollectionFn.get();
            result.addAll(acc);
            return result;
        }).andFinish(FunctionEx.identity());
    }

    public static <T> AggregateOperation1<T, List<T>, List<T>> toList() {
        return AggregateOperations.toCollection(ArrayList::new);
    }

    public static <T> AggregateOperation1<T, Set<T>, Set<T>> toSet() {
        return AggregateOperations.toCollection(HashSet::new);
    }

    public static <T, K, U> AggregateOperation1<T, Map<K, U>, Map<K, U>> toMap(FunctionEx<? super T, ? extends K> keyFn, FunctionEx<? super T, ? extends U> valueFn) {
        Util.checkSerializable(keyFn, "keyFn");
        Util.checkSerializable(valueFn, "valueFn");
        return AggregateOperations.toMap(keyFn, valueFn, (BinaryOperatorEx & Serializable)(k, v) -> {
            throw new IllegalStateException("Duplicate key: " + k);
        }, HashMap::new);
    }

    public static <T, K, U> AggregateOperation1<T, Map<K, U>, Map<K, U>> toMap(FunctionEx<? super T, ? extends K> keyFn, FunctionEx<? super T, ? extends U> valueFn, BinaryOperatorEx<U> mergeFn) {
        Util.checkSerializable(keyFn, "keyFn");
        Util.checkSerializable(valueFn, "valueFn");
        return AggregateOperations.toMap(keyFn, valueFn, mergeFn, HashMap::new);
    }

    public static <T, K, U, M extends Map<K, U>> AggregateOperation1<T, M, M> toMap(FunctionEx<? super T, ? extends K> keyFn, FunctionEx<? super T, ? extends U> valueFn, BinaryOperatorEx<U> mergeFn, SupplierEx<M> createMapFn) {
        Util.checkSerializable(keyFn, "keyFn");
        Util.checkSerializable(valueFn, "valueFn");
        Util.checkSerializable(mergeFn, "mergeFn");
        Util.checkSerializable(createMapFn, "createMapFn");
        BiConsumerEx & Serializable accumulateFn = (BiConsumerEx & Serializable)(map, element) -> map.merge(keyFn.apply(element), valueFn.apply(element), mergeFn);
        return AggregateOperation.withCreate(createMapFn).andAccumulate(accumulateFn).andCombine((BiConsumerEx & Serializable)(l, r) -> r.forEach((key, value) -> l.merge(key, value, mergeFn))).andExport((FunctionEx & Serializable)acc -> {
            Map result = (Map)createMapFn.get();
            result.putAll(acc);
            return result;
        }).andFinish(FunctionEx.identity());
    }

    public static <T, K> AggregateOperation1<T, Map<K, List<T>>, Map<K, List<T>>> groupingBy(FunctionEx<? super T, ? extends K> keyFn) {
        Util.checkSerializable(keyFn, "keyFn");
        return AggregateOperations.groupingBy(keyFn, AggregateOperations.toList());
    }

    public static <T, K, A, R> AggregateOperation1<T, Map<K, A>, Map<K, R>> groupingBy(FunctionEx<? super T, ? extends K> keyFn, AggregateOperation1<? super T, A, R> downstream) {
        Util.checkSerializable(keyFn, "keyFn");
        return AggregateOperations.groupingBy(keyFn, HashMap::new, downstream);
    }

    public static <T, K, R, A, M extends Map<K, R>> AggregateOperation1<T, Map<K, A>, M> groupingBy(FunctionEx<? super T, ? extends K> keyFn, SupplierEx<M> createMapFn, AggregateOperation1<? super T, A, R> downstream) {
        Util.checkSerializable(keyFn, "keyFn");
        Util.checkSerializable(createMapFn, "createMapFn");
        BiConsumerEx & Serializable accumulateFn = (BiConsumerEx & Serializable)(m, t) -> {
            Object acc = m.computeIfAbsent(keyFn.apply(t), k -> downstream.createFn().get());
            downstream.accumulateFn().accept(acc, t);
        };
        BiConsumerEx downstreamCombineFn = downstream.combineFn();
        BiConsumerEx & Serializable combineFn = downstreamCombineFn != null ? (BiConsumerEx & Serializable)(l, r) -> r.forEach((key, value) -> l.merge(key, value, (a, b) -> {
            downstreamCombineFn.accept(a, b);
            return a;
        })) : null;
        SupplierEx<M> createAccMapFn = createMapFn;
        return AggregateOperation.withCreate(createAccMapFn).andAccumulate(accumulateFn).andCombine(combineFn).andExport((FunctionEx & Serializable)accMap -> accMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, (? super T e) -> downstream.exportFn().apply(e.getValue())))).andFinish((FunctionEx & Serializable)accMap -> {
            accMap.replaceAll((k, v) -> downstream.finishFn().apply(v));
            return accMap;
        });
    }

    @Nonnull
    public static <T, A> AggregateOperation1<T, MutableReference<A>, A> reducing(@Nonnull A emptyAccValue, @Nonnull FunctionEx<? super T, ? extends A> toAccValueFn, @Nonnull BinaryOperatorEx<A> combineAccValuesFn, @Nullable BinaryOperatorEx<A> deductAccValueFn) {
        Util.checkSerializable(emptyAccValue, "emptyAccValue");
        Util.checkSerializable(toAccValueFn, "toAccValueFn");
        Util.checkSerializable(combineAccValuesFn, "combineAccValuesFn");
        Util.checkSerializable(deductAccValueFn, "deductAccValueFn");
        BinaryOperatorEx deductFn = deductAccValueFn;
        return AggregateOperation.withCreate((SupplierEx & Serializable)() -> new MutableReference<Object>(emptyAccValue)).andAccumulate((BiConsumerEx & Serializable)(a, t) -> a.set(combineAccValuesFn.apply(a.get(), toAccValueFn.apply(t)))).andCombine((BiConsumerEx & Serializable)(a, b) -> a.set(combineAccValuesFn.apply(a.get(), b.get()))).andDeduct(deductFn != null ? (BiConsumerEx & Serializable)(a, b) -> a.set(deductFn.apply(a.get(), b.get())) : null).andExportFinish(MutableReference::get);
    }

    @Nonnull
    public static <T> AggregateOperation1<T, MutableReference<T>, T> pickAny() {
        return AggregateOperation.withCreate(MutableReference::new).andAccumulate((BiConsumerEx & Serializable)(acc, item) -> {
            if (acc.isNull()) {
                acc.set(item);
            }
        }).andCombine((BiConsumerEx & Serializable)(acc1, acc2) -> {
            if (acc1.isNull()) {
                acc1.set(acc2.get());
            }
        }).andExportFinish(MutableReference::get);
    }

    public static <T> AggregateOperation1<T, ArrayList<T>, List<T>> sorting(@Nonnull ComparatorEx<? super T> comparator) {
        Util.checkSerializable(comparator, "comparator");
        return AggregateOperation.withCreate(ArrayList::new).andAccumulate(ArrayList::add).andCombine(ArrayList::addAll).andExport((FunctionEx & Serializable)acc -> {
            acc.sort(comparator);
            return new ArrayList(acc);
        }).andFinish((FunctionEx & Serializable)list -> {
            list.sort(comparator);
            return list;
        });
    }

    @Nonnull
    public static <T, A0, A1, R0, R1, R> AggregateOperation1<T, Tuple2<A0, A1>, R> allOf(@Nonnull AggregateOperation1<? super T, A0, ? extends R0> op0, @Nonnull AggregateOperation1<? super T, A1, ? extends R1> op1, @Nonnull BiFunctionEx<? super R0, ? super R1, ? extends R> exportFinishFn) {
        Util.checkSerializable(exportFinishFn, "exportFinishFn");
        BiConsumerEx combine0 = op0.combineFn();
        BiConsumerEx combine1 = op1.combineFn();
        BiConsumerEx deduct0 = op0.deductFn();
        BiConsumerEx deduct1 = op1.deductFn();
        return AggregateOperation.withCreate((SupplierEx & Serializable)() -> Tuple2.tuple2(op0.createFn().get(), op1.createFn().get())).andAccumulate((BiConsumerEx & Serializable)(acc, item) -> {
            op0.accumulateFn().accept(acc.f0(), item);
            op1.accumulateFn().accept(acc.f1(), item);
        }).andCombine(combine0 == null || combine1 == null ? null : (BiConsumerEx & Serializable)(acc1, acc2) -> {
            combine0.accept(acc1.f0(), acc2.f0());
            combine1.accept(acc1.f1(), acc2.f1());
        }).andDeduct(deduct0 == null || deduct1 == null ? null : (BiConsumerEx & Serializable)(acc1, acc2) -> {
            deduct0.accept(acc1.f0(), acc2.f0());
            deduct1.accept(acc1.f1(), acc2.f1());
        }).andExport((FunctionEx & Serializable)acc -> exportFinishFn.apply(op0.exportFn().apply(acc.f0()), op1.exportFn().apply(acc.f1()))).andFinish((FunctionEx & Serializable)acc -> exportFinishFn.apply(op0.finishFn().apply(acc.f0()), op1.finishFn().apply(acc.f1())));
    }

    @Nonnull
    public static <T, A0, A1, R0, R1> AggregateOperation1<T, Tuple2<A0, A1>, Tuple2<R0, R1>> allOf(@Nonnull AggregateOperation1<? super T, A0, R0> op1, @Nonnull AggregateOperation1<? super T, A1, R1> op2) {
        return AggregateOperations.allOf(op1, op2, Tuple2::tuple2);
    }

    @Nonnull
    public static <T, A0, A1, A2, R0, R1, R2, R> AggregateOperation1<T, Tuple3<A0, A1, A2>, R> allOf(@Nonnull AggregateOperation1<? super T, A0, ? extends R0> op0, @Nonnull AggregateOperation1<? super T, A1, ? extends R1> op1, @Nonnull AggregateOperation1<? super T, A2, ? extends R2> op2, @Nonnull TriFunction<? super R0, ? super R1, ? super R2, ? extends R> exportFinishFn) {
        Util.checkSerializable(exportFinishFn, "exportFinishFn");
        BiConsumerEx combine0 = op0.combineFn();
        BiConsumerEx combine1 = op1.combineFn();
        BiConsumerEx combine2 = op2.combineFn();
        BiConsumerEx deduct0 = op0.deductFn();
        BiConsumerEx deduct1 = op1.deductFn();
        BiConsumerEx deduct2 = op2.deductFn();
        return AggregateOperation.withCreate((SupplierEx & Serializable)() -> Tuple3.tuple3(op0.createFn().get(), op1.createFn().get(), op2.createFn().get())).andAccumulate((BiConsumerEx & Serializable)(acc, item) -> {
            op0.accumulateFn().accept(acc.f0(), item);
            op1.accumulateFn().accept(acc.f1(), item);
            op2.accumulateFn().accept(acc.f2(), item);
        }).andCombine(combine0 == null || combine1 == null || combine2 == null ? null : (BiConsumerEx & Serializable)(acc1, acc2) -> {
            combine0.accept(acc1.f0(), acc2.f0());
            combine1.accept(acc1.f1(), acc2.f1());
            combine2.accept(acc1.f2(), acc2.f2());
        }).andDeduct(deduct0 == null || deduct1 == null || deduct2 == null ? null : (BiConsumerEx & Serializable)(acc1, acc2) -> {
            deduct0.accept(acc1.f0(), acc2.f0());
            deduct1.accept(acc1.f1(), acc2.f1());
            deduct2.accept(acc1.f2(), acc2.f2());
        }).andExport((FunctionEx & Serializable)acc -> exportFinishFn.apply((Object)op0.exportFn().apply(acc.f0()), (Object)op1.exportFn().apply(acc.f1()), (Object)op2.exportFn().apply(acc.f2()))).andFinish((FunctionEx & Serializable)acc -> exportFinishFn.apply((Object)op0.finishFn().apply(acc.f0()), (Object)op1.finishFn().apply(acc.f1()), (Object)op2.finishFn().apply(acc.f2())));
    }

    @Nonnull
    public static <T, A0, A1, A2, R0, R1, R2> AggregateOperation1<T, Tuple3<A0, A1, A2>, Tuple3<R0, R1, R2>> allOf(@Nonnull AggregateOperation1<? super T, A0, ? extends R0> op0, @Nonnull AggregateOperation1<? super T, A1, ? extends R1> op1, @Nonnull AggregateOperation1<? super T, A2, ? extends R2> op2) {
        return AggregateOperations.allOf(op0, op1, op2, Tuple3::tuple3);
    }

    @Nonnull
    public static <T> AllOfAggregationBuilder<T> allOfBuilder() {
        return new AllOfAggregationBuilder();
    }

    public static <T0, A0, R0, T1, A1, R1, R> AggregateOperation2<T0, T1, Tuple2<A0, A1>, R> aggregateOperation2(@Nonnull AggregateOperation1<? super T0, A0, ? extends R0> op0, @Nonnull AggregateOperation1<? super T1, A1, ? extends R1> op1, @Nonnull BiFunctionEx<? super R0, ? super R1, ? extends R> exportFinishFn) {
        Util.checkSerializable(exportFinishFn, "exportFinishFn");
        BiConsumerEx combine0 = op0.combineFn();
        BiConsumerEx combine1 = op1.combineFn();
        BiConsumerEx deduct0 = op0.deductFn();
        BiConsumerEx deduct1 = op1.deductFn();
        return AggregateOperation.withCreate((SupplierEx & Serializable)() -> Tuple2.tuple2(op0.createFn().get(), op1.createFn().get())).andAccumulate0((BiConsumerEx & Serializable)(acc, item) -> op0.accumulateFn().accept(acc.f0(), item)).andAccumulate1((BiConsumerEx & Serializable)(acc, item) -> op1.accumulateFn().accept(acc.f1(), item)).andCombine(combine0 == null || combine1 == null ? null : (BiConsumerEx & Serializable)(acc1, acc2) -> {
            combine0.accept(acc1.f0(), acc2.f0());
            combine1.accept(acc1.f1(), acc2.f1());
        }).andDeduct(deduct0 == null || deduct1 == null ? null : (BiConsumerEx & Serializable)(acc1, acc2) -> {
            deduct0.accept(acc1.f0(), acc2.f0());
            deduct1.accept(acc1.f1(), acc2.f1());
        }).andExport((FunctionEx & Serializable)acc -> exportFinishFn.apply(op0.exportFn().apply(acc.f0()), op1.exportFn().apply(acc.f1()))).andFinish((FunctionEx & Serializable)acc -> exportFinishFn.apply(op0.finishFn().apply(acc.f0()), op1.finishFn().apply(acc.f1())));
    }

    public static <T0, T1, A0, A1, R0, R1> AggregateOperation2<T0, T1, Tuple2<A0, A1>, Tuple2<R0, R1>> aggregateOperation2(@Nonnull AggregateOperation1<? super T0, A0, ? extends R0> op0, @Nonnull AggregateOperation1<? super T1, A1, ? extends R1> op1) {
        return AggregateOperations.aggregateOperation2(op0, op1, Tuple2::tuple2);
    }

    public static <T0, T1, T2, A0, A1, A2, R0, R1, R2, R> AggregateOperation3<T0, T1, T2, Tuple3<A0, A1, A2>, R> aggregateOperation3(@Nonnull AggregateOperation1<? super T0, A0, ? extends R0> op0, @Nonnull AggregateOperation1<? super T1, A1, ? extends R1> op1, @Nonnull AggregateOperation1<? super T2, A2, ? extends R2> op2, @Nonnull TriFunction<? super R0, ? super R1, ? super R2, ? extends R> exportFinishFn) {
        Util.checkSerializable(exportFinishFn, "exportFinishFn");
        BiConsumerEx combine0 = op0.combineFn();
        BiConsumerEx combine1 = op1.combineFn();
        BiConsumerEx combine2 = op2.combineFn();
        BiConsumerEx deduct0 = op0.deductFn();
        BiConsumerEx deduct1 = op1.deductFn();
        BiConsumerEx deduct2 = op2.deductFn();
        return AggregateOperation.withCreate((SupplierEx & Serializable)() -> Tuple3.tuple3(op0.createFn().get(), op1.createFn().get(), op2.createFn().get())).andAccumulate0((BiConsumerEx & Serializable)(acc, item) -> op0.accumulateFn().accept(acc.f0(), item)).andAccumulate1((BiConsumerEx & Serializable)(acc, item) -> op1.accumulateFn().accept(acc.f1(), item)).andAccumulate2((BiConsumerEx & Serializable)(acc, item) -> op2.accumulateFn().accept(acc.f2(), item)).andCombine(combine0 == null || combine1 == null || combine2 == null ? null : (BiConsumerEx & Serializable)(acc1, acc2) -> {
            combine0.accept(acc1.f0(), acc2.f0());
            combine1.accept(acc1.f1(), acc2.f1());
            combine2.accept(acc1.f2(), acc2.f2());
        }).andDeduct(deduct0 == null || deduct1 == null || deduct2 == null ? null : (BiConsumerEx & Serializable)(acc1, acc2) -> {
            deduct0.accept(acc1.f0(), acc2.f0());
            deduct1.accept(acc1.f1(), acc2.f1());
            deduct2.accept(acc1.f2(), acc2.f2());
        }).andExport((FunctionEx & Serializable)acc -> exportFinishFn.apply((Object)op0.exportFn().apply(acc.f0()), (Object)op1.exportFn().apply(acc.f1()), (Object)op2.exportFn().apply(acc.f2()))).andFinish((FunctionEx & Serializable)acc -> exportFinishFn.apply((Object)op0.finishFn().apply(acc.f0()), (Object)op1.finishFn().apply(acc.f1()), (Object)op2.finishFn().apply(acc.f2())));
    }

    public static <T0, T1, T2, A0, A1, A2, R0, R1, R2> AggregateOperation3<T0, T1, T2, Tuple3<A0, A1, A2>, Tuple3<R0, R1, R2>> aggregateOperation3(@Nonnull AggregateOperation1<? super T0, A0, ? extends R0> op0, @Nonnull AggregateOperation1<? super T1, A1, ? extends R1> op1, @Nonnull AggregateOperation1<? super T2, A2, ? extends R2> op2) {
        return AggregateOperations.aggregateOperation3(op0, op1, op2, Tuple3::tuple3);
    }

    @Nonnull
    public static CoAggregateOperationBuilder coAggregateOperationBuilder() {
        return new CoAggregateOperationBuilder();
    }

    @Nonnull
    public static <T, A, R> Collector<T, A, R> toCollector(AggregateOperation1<? super T, A, ? extends R> aggrOp) {
        BiConsumerEx combineFn = aggrOp.combineFn();
        if (combineFn == null) {
            throw new IllegalArgumentException("This aggregate operation doesn't implement combineFn()");
        }
        return Collector.of(aggrOp.createFn(), (acc, t) -> aggrOp.accumulateFn().accept(acc, t), (l, r) -> {
            combineFn.accept(l, r);
            return l;
        }, a -> aggrOp.finishFn().apply(a), new Collector.Characteristics[0]);
    }

    @Nonnull
    public static <T, A, R> Aggregator<T, R> toAggregator(AggregateOperation1<? super T, A, ? extends R> aggrOp) {
        return new AggregateOpAggregator<T, A, R>(aggrOp);
    }
}

