/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.execution.init;

import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.nio.serialization.SerializerHook;
import com.hazelcast.nio.serialization.StreamSerializer;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;

public final class CustomClassLoadedObject {
    protected final Object object;

    private CustomClassLoadedObject(Object object) {
        this.object = object;
    }

    public static void write(ObjectDataOutput out, Serializable object) throws IOException {
        out.writeObject((Object)new CustomClassLoadedObject(object));
    }

    public static <T> T read(ObjectDataInput input) throws IOException {
        return (T)((CustomClassLoadedObject)input.readObject()).object;
    }

    public static <T> T deserializeWithCustomClassLoader(SerializationService serializationService, ClassLoader cl, Data data) {
        ClassLoader previous = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(cl);
        try {
            Object object = serializationService.toObject((Object)data);
            return (T)object;
        }
        catch (HazelcastSerializationException e) {
            throw ExceptionUtil.handleSerializedLambdaCce(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(previous);
        }
    }

    public static final class Serializer
    implements StreamSerializer<CustomClassLoadedObject> {
        @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST", "OS_OPEN_STREAM"})
        public void write(ObjectDataOutput out, CustomClassLoadedObject object) throws IOException {
            boolean isJavaSerialized = !(object.object instanceof DataSerializable);
            out.writeBoolean(isJavaSerialized);
            if (isJavaSerialized) {
                ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)out);
                objectOutputStream.writeObject(object.object);
                objectOutputStream.flush();
            } else {
                out.writeObject(object.object);
            }
        }

        @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST", "OS_OPEN_STREAM"})
        public CustomClassLoadedObject read(ObjectDataInput in) throws IOException {
            Object object;
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            boolean isJavaSerialized = in.readBoolean();
            if (isJavaSerialized) {
                ObjectInputStream objectInputStream = IOUtil.newObjectInputStream((ClassLoader)cl, null, (InputStream)((InputStream)in));
                try {
                    object = objectInputStream.readObject();
                }
                catch (ClassNotFoundException e) {
                    throw new HazelcastSerializationException((Throwable)e);
                }
            } else {
                object = in.readObject();
            }
            return new CustomClassLoadedObject(object);
        }

        public int getTypeId() {
            return -301;
        }
    }

    public static final class Hook
    implements SerializerHook<CustomClassLoadedObject> {
        public Class<CustomClassLoadedObject> getSerializationType() {
            return CustomClassLoadedObject.class;
        }

        public Serializer createSerializer() {
            return new Serializer();
        }

        public boolean isOverwritable() {
            return false;
        }
    }
}

