/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.config;

import com.hazelcast.config.AbstractXmlConfigBuilder;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.instance.BuildInfo;
import com.hazelcast.instance.BuildInfoProvider;
import com.hazelcast.instance.JetBuildInfo;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.jet.config.JetConfig;
import com.hazelcast.jet.impl.config.ConfigProvider;
import com.hazelcast.jet.impl.config.JetDomConfigProcessor;
import com.hazelcast.jet.impl.config.XmlJetConfigLocator;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.io.Closeable;
import java.io.InputStream;
import java.util.Properties;
import javax.annotation.Nullable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class XmlJetConfigBuilder
extends AbstractXmlConfigBuilder {
    private static final ILogger LOGGER = Logger.getLogger(XmlJetConfigBuilder.class);
    private final InputStream in;

    public XmlJetConfigBuilder() {
        this((XmlJetConfigLocator)null);
    }

    public XmlJetConfigBuilder(InputStream inputStream) {
        Preconditions.checkTrue((inputStream != null ? 1 : 0) != 0, (String)"inputStream can't be null");
        this.in = inputStream;
    }

    public XmlJetConfigBuilder(XmlJetConfigLocator locator) {
        if (locator == null) {
            locator = new XmlJetConfigLocator();
            locator.locateEverywhere();
        }
        this.in = locator.getIn();
    }

    public XmlJetConfigBuilder setProperties(@Nullable Properties properties) {
        if (properties == null) {
            properties = System.getProperties();
        }
        this.setPropertiesInternal(properties);
        return this;
    }

    @Deprecated
    public static JetConfig loadConfig(@Nullable InputStream stream, @Nullable Properties properties) {
        if (stream == null) {
            XmlJetConfigLocator locator = new XmlJetConfigLocator();
            locator.locateEverywhere();
            stream = locator.getIn();
        }
        JetConfig cfg = new XmlJetConfigBuilder(stream).setProperties(properties).build();
        cfg.setHazelcastConfig(ConfigProvider.locateAndGetMemberConfig(properties));
        return cfg;
    }

    protected Document parse(InputStream inputStream) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        DocumentBuilder builder = dbf.newDocumentBuilder();
        try {
            Document document = builder.parse(inputStream);
            return document;
        }
        catch (Exception e) {
            String msg = "Failed to parse config" + StringUtil.LINE_SEPARATOR + "Exception: " + e.getMessage() + StringUtil.LINE_SEPARATOR + "Hazelcast Jet startup interrupted.";
            LOGGER.severe(msg);
            throw new InvalidConfigurationException(e.getMessage(), (Throwable)e);
        }
        finally {
            IOUtil.closeResource((Closeable)inputStream);
        }
    }

    protected AbstractXmlConfigBuilder.ConfigType getConfigType() {
        return AbstractXmlConfigBuilder.ConfigType.JET;
    }

    public String getNamespaceType() {
        return "jet-config";
    }

    public String getReleaseVersion() {
        BuildInfo buildInfo = BuildInfoProvider.getBuildInfo();
        JetBuildInfo jetBuildInfo = buildInfo.getJetBuildInfo();
        return jetBuildInfo.getVersion().substring(0, 3);
    }

    public JetConfig build() {
        return this.build(new JetConfig());
    }

    public JetConfig build(JetConfig config) {
        try {
            this.parseAndBuildConfig(config);
        }
        catch (Exception e) {
            throw ExceptionUtil.sneakyThrow(e);
        }
        finally {
            IOUtil.closeResource((Closeable)this.in);
        }
        config.setHazelcastConfig(ConfigProvider.locateAndGetMemberConfig(this.getProperties()));
        return config;
    }

    private void parseAndBuildConfig(JetConfig config) throws Exception {
        Document doc = this.parse(this.in);
        Element root = doc.getDocumentElement();
        try {
            root.getTextContent();
        }
        catch (Throwable e) {
            this.domLevel3 = false;
        }
        this.process(root);
        this.schemaValidation(root.getOwnerDocument());
        new JetDomConfigProcessor(this.domLevel3, config).buildConfig(root);
    }
}

