/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.cluster.Cluster;
import com.hazelcast.collection.IList;
import com.hazelcast.config.Config;
import com.hazelcast.config.DiscoveryConfig;
import com.hazelcast.config.JoinConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.jet.Jet;
import com.hazelcast.jet.JetCacheManager;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.Job;
import com.hazelcast.jet.Observable;
import com.hazelcast.jet.config.JetConfig;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.core.DAG;
import com.hazelcast.jet.impl.AbstractJetInstance;
import com.hazelcast.jet.impl.config.ConfigProvider;
import com.hazelcast.jet.impl.util.ConcurrentMemoizingSupplier;
import com.hazelcast.jet.impl.util.JetConsoleLogHandler;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.map.IMap;
import com.hazelcast.replicatedmap.ReplicatedMap;
import com.hazelcast.spi.properties.ClusterProperty;
import com.hazelcast.topic.ITopic;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.jar.JarFile;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class JetBootstrap {
    private static ConcurrentMemoizingSupplier<JetInstance> supplier;
    private static final ILogger LOGGER;
    private static final AtomicBoolean LOGGING_CONFIGURED;

    private JetBootstrap() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void executeJar(@Nonnull Supplier<JetInstance> supplier, @Nonnull String jar, @Nullable String snapshotName, @Nullable String jobName, @Nullable String mainClass, @Nonnull List<String> args) throws Exception {
        if (JetBootstrap.supplier != null) {
            throw new IllegalStateException("Supplier was already set. This method should not be called outside the Jet command line.");
        }
        JetBootstrap.supplier = new ConcurrentMemoizingSupplier<JetInstance>(() -> new InstanceProxy((JetInstance)supplier.get(), jar, snapshotName, jobName));
        try (JarFile jarFile = new JarFile(jar);){
            URL jarUrl;
            URLClassLoader classLoader;
            Class<?> clazz;
            Method main;
            int mods;
            if (StringUtil.isNullOrEmpty((String)mainClass)) {
                if (jarFile.getManifest() == null) {
                    JetBootstrap.error("No manifest file in " + jar + ". The -c option can be used to provide a main class.");
                }
                if ((mainClass = jarFile.getManifest().getMainAttributes().getValue("Main-Class")) == null) {
                    JetBootstrap.error("No Main-Class found in manifest. The -c option can be used to provide a main class.");
                }
            }
            if (((mods = (main = (clazz = JetBootstrap.loadMainClass(classLoader = AccessController.doPrivileged(() -> JetBootstrap.lambda$executeJar$1(jarUrl = new URL("file:///" + jar))), mainClass)).getDeclaredMethod("main", String[].class)).getModifiers()) & 1) == 0 || (mods & 8) == 0) {
                JetBootstrap.error("Class " + clazz.getName() + " has a main(String[] args) method which is not public static");
            }
            String[] jobArgs = args.toArray(new String[0]);
            main.invoke(null, new Object[]{jobArgs});
        }
        finally {
            JetInstance remembered = JetBootstrap.supplier.remembered();
            if (remembered != null) {
                try {
                    remembered.shutdown();
                }
                catch (Throwable t) {
                    System.err.println("Shutdown failed with:");
                    t.printStackTrace();
                }
            }
            JetBootstrap.supplier = null;
        }
    }

    private static Class<?> loadMainClass(ClassLoader classLoader, String mainClass) throws ClassNotFoundException {
        try {
            return classLoader.loadClass(mainClass);
        }
        catch (ClassNotFoundException e) {
            System.err.println("Cannot find or load main class: " + mainClass);
            throw e;
        }
    }

    private static void error(String msg) {
        System.err.println(msg);
        System.exit(1);
    }

    @Nonnull
    public static synchronized JetInstance getInstance() {
        if (supplier == null) {
            supplier = new ConcurrentMemoizingSupplier<JetInstance>(() -> new InstanceProxy(JetBootstrap.createStandaloneInstance()));
        }
        return supplier.get();
    }

    private static JetInstance createStandaloneInstance() {
        JetBootstrap.configureLogging();
        LOGGER.info("Bootstrapped instance requested but application wasn't called from jet submit script. Creating a standalone Jet instance instead.");
        JetConfig config = ConfigProvider.locateAndGetJetConfig();
        Config hzConfig = config.getHazelcastConfig();
        hzConfig.setProperty("hazelcast.wait.seconds.before.join", "0");
        hzConfig.getAdvancedNetworkConfig().setEnabled(false);
        JoinConfig join = hzConfig.getNetworkConfig().getJoin();
        join.getMulticastConfig().setEnabled(false);
        join.getTcpIpConfig().setEnabled(false);
        join.getAwsConfig().setEnabled(false);
        join.getGcpConfig().setEnabled(false);
        join.getAzureConfig().setEnabled(false);
        join.getKubernetesConfig().setEnabled(false);
        join.getEurekaConfig().setEnabled(false);
        join.setDiscoveryConfig(new DiscoveryConfig());
        return Jet.newJetInstance(config);
    }

    public static void configureLogging() {
        if (LOGGING_CONFIGURED.compareAndSet(false, true)) {
            try {
                String loggingType = System.getProperty(ClusterProperty.LOGGING_TYPE.getName(), "jdk");
                if (loggingType.equals("jdk")) {
                    java.util.logging.Logger rootLogger = LogManager.getLogManager().getLogger("");
                    for (Handler handler : rootLogger.getHandlers()) {
                        if (!(handler instanceof ConsoleHandler)) continue;
                        rootLogger.removeHandler(handler);
                        rootLogger.addHandler(new JetConsoleLogHandler());
                        rootLogger.setLevel(Level.INFO);
                        return;
                    }
                }
            }
            catch (Exception e) {
                System.err.println("Error configuring java.util.logging for Jet: " + e);
            }
        }
    }

    private static /* synthetic */ URLClassLoader lambda$executeJar$1(URL jarUrl) {
        return new URLClassLoader(new URL[]{jarUrl}, JetBootstrap.class.getClassLoader());
    }

    static {
        LOGGER = Logger.getLogger((String)Jet.class.getName());
        LOGGING_CONFIGURED = new AtomicBoolean(false);
    }

    private static class InstanceProxy
    extends AbstractJetInstance {
        private final AbstractJetInstance instance;
        private final String jar;
        private final String snapshotName;
        private final String jobName;

        InstanceProxy(JetInstance hazelcastInstance) {
            this(hazelcastInstance, null, null, null);
        }

        InstanceProxy(JetInstance instance, @Nullable String jar, @Nullable String snapshotName, @Nullable String jobName) {
            super(instance.getHazelcastInstance());
            this.instance = (AbstractJetInstance)instance;
            this.jar = jar;
            this.snapshotName = snapshotName;
            this.jobName = jobName;
        }

        @Override
        @Nonnull
        public String getName() {
            return this.instance.getName();
        }

        @Override
        @Nonnull
        public HazelcastInstance getHazelcastInstance() {
            return this.instance.getHazelcastInstance();
        }

        @Override
        @Nonnull
        public Cluster getCluster() {
            return this.instance.getCluster();
        }

        @Override
        @Nonnull
        public JetConfig getConfig() {
            return this.instance.getConfig();
        }

        @Override
        @Nonnull
        public Job newJob(@Nonnull DAG dag, @Nonnull JobConfig config) {
            return this.instance.newJob(dag, this.updateJobConfig(config));
        }

        @Override
        @Nonnull
        public Job newJobIfAbsent(@Nonnull DAG dag, @Nonnull JobConfig config) {
            return this.instance.newJobIfAbsent(dag, this.updateJobConfig(config));
        }

        private JobConfig updateJobConfig(@Nonnull JobConfig config) {
            if (this.jar != null) {
                config.addJar(this.jar);
            }
            if (this.snapshotName != null) {
                config.setInitialSnapshotName(this.snapshotName);
            }
            if (this.jobName != null) {
                config.setName(this.jobName);
            }
            return config;
        }

        @Override
        @Nonnull
        public List<Job> getJobs() {
            return this.instance.getJobs();
        }

        @Override
        public Job getJob(long jobId) {
            return this.instance.getJob(jobId);
        }

        @Override
        @Nonnull
        public List<Job> getJobs(@Nonnull String name) {
            return this.instance.getJobs(name);
        }

        @Override
        @Nonnull
        public <K, V> IMap<K, V> getMap(@Nonnull String name) {
            return this.instance.getMap(name);
        }

        @Override
        @Nonnull
        public <K, V> ReplicatedMap<K, V> getReplicatedMap(@Nonnull String name) {
            return this.instance.getReplicatedMap(name);
        }

        @Override
        @Nonnull
        public JetCacheManager getCacheManager() {
            return this.instance.getCacheManager();
        }

        @Override
        @Nonnull
        public <E> IList<E> getList(@Nonnull String name) {
            return this.instance.getList(name);
        }

        @Override
        @Nonnull
        public <T> ITopic<T> getReliableTopic(@Nonnull String name) {
            return this.instance.getReliableTopic(name);
        }

        @Override
        @Nonnull
        public <T> Observable<T> getObservable(@Nonnull String name) {
            return this.instance.getObservable(name);
        }

        @Override
        public void shutdown() {
            this.instance.shutdown();
        }

        @Override
        public boolean existsDistributedObject(@Nonnull String serviceName, @Nonnull String objectName) {
            return this.instance.existsDistributedObject(serviceName, objectName);
        }

        @Override
        public ILogger getLogger() {
            return this.instance.getLogger();
        }

        @Override
        public Job newJobProxy(long jobId) {
            return this.instance.newJobProxy(jobId);
        }

        @Override
        public Job newJobProxy(long jobId, DAG dag, JobConfig config) {
            return this.instance.newJobProxy(jobId, dag, config);
        }

        @Override
        public List<Long> getJobIdsByName(String name) {
            return this.instance.getJobIdsByName(name);
        }
    }
}

