/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.config;

import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.annotation.EvolvingApi;
import com.hazelcast.jet.config.JetConfigDataSerializerHook;
import com.hazelcast.jet.config.JobClassLoaderFactory;
import com.hazelcast.jet.config.ProcessingGuarantee;
import com.hazelcast.jet.config.ResourceConfig;
import com.hazelcast.jet.config.ResourceType;
import com.hazelcast.jet.impl.util.ReflectionUtils;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.nio.serialization.StreamSerializer;
import com.hazelcast.spi.annotation.PrivateApi;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JobConfig
implements IdentifiedDataSerializable {
    private static final long SNAPSHOT_INTERVAL_MILLIS_DEFAULT = TimeUnit.SECONDS.toMillis(10L);
    private String name;
    private ProcessingGuarantee processingGuarantee = ProcessingGuarantee.NONE;
    private long snapshotIntervalMillis = SNAPSHOT_INTERVAL_MILLIS_DEFAULT;
    private boolean autoScaling = true;
    private boolean splitBrainProtectionEnabled;
    private boolean enableMetrics = true;
    private boolean storeMetricsAfterJobCompletion;
    private Map<String, ResourceConfig> resourceConfigs = new LinkedHashMap<String, ResourceConfig>();
    private Map<String, String> serializerConfigs = new HashMap<String, String>();
    private JobClassLoaderFactory classLoaderFactory;
    private String initialSnapshotName;

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nonnull
    public JobConfig setName(@Nullable String name) {
        this.name = name;
        return this;
    }

    public boolean isSplitBrainProtectionEnabled() {
        return this.splitBrainProtectionEnabled;
    }

    @Nonnull
    public JobConfig setSplitBrainProtection(boolean isEnabled) {
        this.splitBrainProtectionEnabled = isEnabled;
        return this;
    }

    public JobConfig setAutoScaling(boolean enabled) {
        this.autoScaling = enabled;
        return this;
    }

    public boolean isAutoScaling() {
        return this.autoScaling;
    }

    @Nonnull
    public ProcessingGuarantee getProcessingGuarantee() {
        return this.processingGuarantee;
    }

    @Nonnull
    public JobConfig setProcessingGuarantee(@Nonnull ProcessingGuarantee processingGuarantee) {
        this.processingGuarantee = processingGuarantee;
        return this;
    }

    public long getSnapshotIntervalMillis() {
        return this.snapshotIntervalMillis;
    }

    @Nonnull
    public JobConfig setSnapshotIntervalMillis(long snapshotInterval) {
        Preconditions.checkNotNegative((long)snapshotInterval, (String)"snapshotInterval can't be negative");
        this.snapshotIntervalMillis = snapshotInterval;
        return this;
    }

    @Nonnull
    public JobConfig addClass(Class ... classes) {
        ReflectionUtils.nestedClassesOf(classes).forEach(this::addClass);
        return this;
    }

    @Nonnull
    public JobConfig addPackage(String ... packages) {
        Preconditions.checkNotNull((Object)packages, (String)"Packages cannot be null");
        ReflectionUtils.Resources resources = ReflectionUtils.resourcesOf(packages);
        resources.classes().forEach(classResource -> this.add(classResource.getUrl(), classResource.getId(), ResourceType.CLASS));
        resources.nonClasses().forEach(this::addClasspathResource);
        return this;
    }

    @Nonnull
    public JobConfig addJar(@Nonnull URL url) {
        return this.add(url, JobConfig.filenamePart(url), ResourceType.JAR);
    }

    @Nonnull
    public JobConfig addJar(@Nonnull File file) {
        JobConfig.ensureIsFile(file);
        return this.addJar(JobConfig.fileToUrl(file));
    }

    @Nonnull
    public JobConfig addJar(@Nonnull String path) {
        return this.addJar(new File(path));
    }

    @Nonnull
    public JobConfig addJarsInZip(@Nonnull URL url) {
        return this.add(url, JobConfig.filenamePart(url), ResourceType.JARS_IN_ZIP);
    }

    @Nonnull
    public JobConfig addJarsInZip(@Nonnull File file) {
        JobConfig.ensureIsFile(file);
        return this.addJarsInZip(JobConfig.fileToUrl(file));
    }

    @Nonnull
    public JobConfig addJarsInZip(@Nonnull String path) {
        return this.addJarsInZip(new File(path));
    }

    @Nonnull
    public JobConfig addClasspathResource(@Nonnull URL url) {
        return this.addClasspathResource(url, JobConfig.filenamePart(url));
    }

    @Nonnull
    public JobConfig addClasspathResource(@Nonnull URL url, @Nonnull String id) {
        return this.add(url, id, ResourceType.CLASSPATH_RESOURCE);
    }

    @Nonnull
    public JobConfig addClasspathResource(@Nonnull File file) {
        JobConfig.ensureIsFile(file);
        return this.addClasspathResource(JobConfig.fileToUrl(file), file.getName());
    }

    @Nonnull
    public JobConfig addClasspathResource(@Nonnull File file, @Nonnull String id) {
        JobConfig.ensureIsFile(file);
        return this.add(JobConfig.fileToUrl(file), id, ResourceType.CLASSPATH_RESOURCE);
    }

    @Nonnull
    public JobConfig addClasspathResource(@Nonnull String path) {
        return this.addClasspathResource(new File(path));
    }

    @Nonnull
    public JobConfig addClasspathResource(@Nonnull String path, @Nonnull String id) {
        return this.addClasspathResource(new File(path), id);
    }

    @Nonnull
    public JobConfig attachFile(@Nonnull URL url) {
        return this.attachFile(url, JobConfig.filenamePart(url));
    }

    @Nonnull
    public JobConfig attachFile(@Nonnull URL url, @Nonnull String id) {
        JobConfig.ensureHasPath(url);
        return this.add(url, id, ResourceType.FILE);
    }

    @Nonnull
    public JobConfig attachFile(@Nonnull File file) {
        return this.attachFile(file, file.getName());
    }

    @Nonnull
    public JobConfig attachFile(@Nonnull File file, @Nonnull String id) {
        JobConfig.ensureIsFile(file);
        return this.attachFile(JobConfig.fileToUrl(file), id);
    }

    @Nonnull
    public JobConfig attachFile(@Nonnull String path) {
        return this.attachFile(new File(path));
    }

    @Nonnull
    public JobConfig attachFile(@Nonnull String path, @Nonnull String id) {
        return this.attachFile(new File(path), id);
    }

    @Nonnull
    public JobConfig attachDirectory(@Nonnull URL url) {
        return this.attachDirectory(url, JobConfig.urlToFile(url).getName());
    }

    @Nonnull
    public JobConfig attachDirectory(@Nonnull URL url, @Nonnull String id) {
        JobConfig.ensureHasPath(url);
        JobConfig.ensureIsDirectory(JobConfig.urlToFile(url));
        return this.add(url, id, ResourceType.DIRECTORY);
    }

    @Nonnull
    public JobConfig attachDirectory(@Nonnull String path) {
        return this.attachDirectory(new File(path));
    }

    @Nonnull
    public JobConfig attachDirectory(@Nonnull String path, @Nonnull String id) {
        return this.attachDirectory(new File(path), id);
    }

    @Nonnull
    public JobConfig attachDirectory(@Nonnull File file) {
        return this.attachDirectory(file, file.getName());
    }

    @Nonnull
    public JobConfig attachDirectory(@Nonnull File file, @Nonnull String id) {
        return this.attachDirectory(JobConfig.fileToUrl(file), id);
    }

    @Nonnull
    public JobConfig attachAll(@Nonnull Map<String, File> idToFile) {
        for (Map.Entry<String, File> e : idToFile.entrySet()) {
            File file = e.getValue();
            if (!file.canRead()) {
                throw new JetException("Not readable: " + file);
            }
            if (file.isDirectory()) {
                this.attachDirectory(file, e.getKey());
                continue;
            }
            if (file.isFile()) {
                this.attachFile(file, e.getKey());
                continue;
            }
            throw new JetException("Neither a regular file nor a directory: " + file);
        }
        return this;
    }

    @Nonnull
    private static String filenamePart(@Nonnull URL url) {
        String filename = new File(url.getPath()).getName();
        Preconditions.checkHasText((String)filename, (String)("URL has no path: " + url));
        return filename;
    }

    private static void ensureHasPath(@Nonnull URL url) {
        if (url.getPath().isEmpty()) {
            throw new IllegalArgumentException("URL has no path part: " + url.toExternalForm());
        }
    }

    private static void ensureIsFile(@Nonnull File file) {
        if (!file.isFile() || !file.canRead()) {
            throw new JetException("Not an existing, readable file: " + file);
        }
    }

    private static void ensureIsDirectory(@Nonnull File path) {
        if (!path.isDirectory() || !path.canRead()) {
            throw new JetException("Not an existing, readable directory: " + path);
        }
    }

    private static URL fileToUrl(@Nonnull File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid file: " + file, e);
        }
    }

    private static File urlToFile(@Nonnull URL url) {
        try {
            return new File(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid directory URL: " + url.toExternalForm(), e);
        }
    }

    @Nonnull
    @PrivateApi
    public Map<String, ResourceConfig> getResourceConfigs() {
        return this.resourceConfigs;
    }

    @Nonnull
    @EvolvingApi
    public <T, S extends StreamSerializer<T>> JobConfig registerSerializer(@Nonnull Class<T> clazz, @Nonnull Class<S> serializerClass) {
        Preconditions.checkFalse((boolean)this.serializerConfigs.containsKey(clazz.getName()), (String)("Serializer for " + clazz + " already registered"));
        this.serializerConfigs.put(clazz.getName(), serializerClass.getName());
        return this;
    }

    @Nonnull
    @PrivateApi
    public Map<String, String> getSerializerConfigs() {
        return this.serializerConfigs;
    }

    private void addClass(@Nonnull Class<?> clazz) {
        ResourceConfig cfg = new ResourceConfig(clazz);
        this.resourceConfigs.put(cfg.getId(), cfg);
    }

    private JobConfig add(@Nonnull URL url, @Nonnull String id, @Nonnull ResourceType resourceType) {
        Preconditions.checkHasText((String)id, (String)"Resource ID is blank");
        ResourceConfig cfg = new ResourceConfig(url, id, resourceType);
        if (this.resourceConfigs.putIfAbsent(id, cfg) != null) {
            throw new IllegalArgumentException("Resource with id:" + id + " already exists");
        }
        return this;
    }

    @Nonnull
    public JobConfig setClassLoaderFactory(@Nullable JobClassLoaderFactory classLoaderFactory) {
        this.classLoaderFactory = classLoaderFactory;
        return this;
    }

    @Nullable
    public JobClassLoaderFactory getClassLoaderFactory() {
        return this.classLoaderFactory;
    }

    @Nullable
    public String getInitialSnapshotName() {
        return this.initialSnapshotName;
    }

    @Nonnull
    public JobConfig setInitialSnapshotName(@Nullable String initialSnapshotName) {
        this.initialSnapshotName = initialSnapshotName;
        return this;
    }

    @Nonnull
    public JobConfig setMetricsEnabled(boolean enabled) {
        this.enableMetrics = enabled;
        return this;
    }

    public boolean isMetricsEnabled() {
        return this.enableMetrics;
    }

    public boolean isStoreMetricsAfterJobCompletion() {
        return this.storeMetricsAfterJobCompletion;
    }

    public JobConfig setStoreMetricsAfterJobCompletion(boolean storeMetricsAfterJobCompletion) {
        this.storeMetricsAfterJobCompletion = storeMetricsAfterJobCompletion;
        return this;
    }

    public int getFactoryId() {
        return JetConfigDataSerializerHook.FACTORY_ID;
    }

    public int getClassId() {
        return 0;
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeObject((Object)this.processingGuarantee);
        out.writeLong(this.snapshotIntervalMillis);
        out.writeBoolean(this.autoScaling);
        out.writeBoolean(this.splitBrainProtectionEnabled);
        out.writeObject(this.resourceConfigs);
        out.writeObject(this.serializerConfigs);
        out.writeObject((Object)this.classLoaderFactory);
        out.writeUTF(this.initialSnapshotName);
        out.writeBoolean(this.enableMetrics);
        out.writeBoolean(this.storeMetricsAfterJobCompletion);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.name = in.readUTF();
        this.processingGuarantee = (ProcessingGuarantee)((Object)in.readObject());
        this.snapshotIntervalMillis = in.readLong();
        this.autoScaling = in.readBoolean();
        this.splitBrainProtectionEnabled = in.readBoolean();
        this.resourceConfigs = (Map)in.readObject();
        this.serializerConfigs = (Map)in.readObject();
        this.classLoaderFactory = (JobClassLoaderFactory)in.readObject();
        this.initialSnapshotName = in.readUTF();
        this.enableMetrics = in.readBoolean();
        this.storeMetricsAfterJobCompletion = in.readBoolean();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobConfig jobConfig = (JobConfig)o;
        return this.snapshotIntervalMillis == jobConfig.snapshotIntervalMillis && this.autoScaling == jobConfig.autoScaling && this.splitBrainProtectionEnabled == jobConfig.splitBrainProtectionEnabled && this.enableMetrics == jobConfig.enableMetrics && this.storeMetricsAfterJobCompletion == jobConfig.storeMetricsAfterJobCompletion && Objects.equals(this.name, jobConfig.name) && this.processingGuarantee == jobConfig.processingGuarantee && Objects.equals(this.resourceConfigs, jobConfig.resourceConfigs) && Objects.equals(this.serializerConfigs, jobConfig.serializerConfigs) && Objects.equals(this.classLoaderFactory, jobConfig.classLoaderFactory) && Objects.equals(this.initialSnapshotName, jobConfig.initialSnapshotName);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.processingGuarantee, this.snapshotIntervalMillis, this.autoScaling, this.splitBrainProtectionEnabled, this.enableMetrics, this.storeMetricsAfterJobCompletion, this.resourceConfigs, this.serializerConfigs, this.classLoaderFactory, this.initialSnapshotName});
    }

    public String toString() {
        return "JobConfig {name=" + this.name + ", processingGuarantee=" + (Object)((Object)this.processingGuarantee) + ", snapshotIntervalMillis=" + this.snapshotIntervalMillis + ", autoScaling=" + this.autoScaling + ", splitBrainProtectionEnabled=" + this.splitBrainProtectionEnabled + ", enableMetrics=" + this.enableMetrics + ", storeMetricsAfterJobCompletion=" + this.storeMetricsAfterJobCompletion + ", resourceConfigs=" + this.resourceConfigs + ", serializerConfigs=" + this.serializerConfigs + ", classLoaderFactory=" + this.classLoaderFactory + ", initialSnapshotName=" + this.initialSnapshotName + "}";
    }
}

