/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.pipeline;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.collection.IList;
import com.hazelcast.function.BiConsumerEx;
import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.function.BinaryOperatorEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.Functions;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.jet.Observable;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.processor.DiagnosticProcessors;
import com.hazelcast.jet.core.processor.Processors;
import com.hazelcast.jet.core.processor.SinkProcessors;
import com.hazelcast.jet.impl.pipeline.SinkImpl;
import com.hazelcast.jet.impl.util.ImdgUtil;
import com.hazelcast.jet.pipeline.FileSinkBuilder;
import com.hazelcast.jet.pipeline.JdbcSinkBuilder;
import com.hazelcast.jet.pipeline.JmsSinkBuilder;
import com.hazelcast.jet.pipeline.Sink;
import com.hazelcast.jet.pipeline.SinkBuilder;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.IMap;
import com.hazelcast.topic.ITopic;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.PreparedStatement;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.jms.ConnectionFactory;
import javax.sql.CommonDataSource;

public final class Sinks {
    private Sinks() {
    }

    @Nonnull
    public static <T> Sink<T> fromProcessor(@Nonnull String sinkName, @Nonnull ProcessorMetaSupplier metaSupplier) {
        return new SinkImpl(sinkName, metaSupplier, false, null);
    }

    @Nonnull
    public static <K, V> Sink<Map.Entry<K, V>> map(@Nonnull String mapName) {
        return new SinkImpl<Map.Entry<K, V>>("mapSink(" + mapName + ')', SinkProcessors.writeMapP(mapName), false, Functions.entryKey());
    }

    @Nonnull
    public static <K, V> Sink<Map.Entry<K, V>> map(@Nonnull IMap<? super K, ? super V> map) {
        return Sinks.map(map.getName());
    }

    @Nonnull
    public static <K, V> Sink<Map.Entry<K, V>> remoteMap(@Nonnull String mapName, @Nonnull ClientConfig clientConfig) {
        return Sinks.fromProcessor("remoteMapSink(" + mapName + ')', SinkProcessors.writeRemoteMapP(mapName, clientConfig));
    }

    @Nonnull
    public static <T, K, V> Sink<T> mapWithMerging(@Nonnull String mapName, @Nonnull FunctionEx<? super T, ? extends K> toKeyFn, @Nonnull FunctionEx<? super T, ? extends V> toValueFn, @Nonnull BinaryOperatorEx<V> mergeFn) {
        return new SinkImpl<T>("mapWithMergingSink(" + mapName + ')', SinkProcessors.mergeMapP(mapName, toKeyFn, toValueFn, mergeFn), false, toKeyFn);
    }

    @Nonnull
    public static <T, K, V> Sink<T> mapWithMerging(@Nonnull IMap<? super K, ? super V> map, @Nonnull FunctionEx<? super T, ? extends K> toKeyFn, @Nonnull FunctionEx<? super T, ? extends V> toValueFn, @Nonnull BinaryOperatorEx<V> mergeFn) {
        return Sinks.mapWithMerging(map.getName(), toKeyFn, toValueFn, mergeFn);
    }

    @Nonnull
    public static <T, K, V> Sink<T> remoteMapWithMerging(@Nonnull String mapName, @Nonnull ClientConfig clientConfig, @Nonnull FunctionEx<? super T, ? extends K> toKeyFn, @Nonnull FunctionEx<? super T, ? extends V> toValueFn, @Nonnull BinaryOperatorEx<V> mergeFn) {
        return Sinks.fromProcessor("remoteMapWithMergingSink(" + mapName + ')', SinkProcessors.mergeRemoteMapP(mapName, clientConfig, toKeyFn, toValueFn, mergeFn));
    }

    @Nonnull
    public static <K, V> Sink<Map.Entry<K, V>> mapWithMerging(@Nonnull String mapName, @Nonnull BinaryOperatorEx<V> mergeFn) {
        return Sinks.mapWithMerging(mapName, Functions.entryKey(), Functions.entryValue(), mergeFn);
    }

    @Nonnull
    public static <K, V> Sink<Map.Entry<K, V>> mapWithMerging(@Nonnull IMap<? super K, V> map, @Nonnull BinaryOperatorEx<V> mergeFn) {
        return Sinks.mapWithMerging(map.getName(), mergeFn);
    }

    @Nonnull
    public static <K, V> Sink<Map.Entry<K, V>> remoteMapWithMerging(@Nonnull String mapName, @Nonnull ClientConfig clientConfig, @Nonnull BinaryOperatorEx<V> mergeFn) {
        return Sinks.fromProcessor("remoteMapWithMergingSink(" + mapName + ')', SinkProcessors.mergeRemoteMapP(mapName, clientConfig, Map.Entry::getKey, Functions.entryValue(), mergeFn));
    }

    @Nonnull
    public static <T, K, V> Sink<T> mapWithUpdating(@Nonnull String mapName, @Nonnull FunctionEx<? super T, ? extends K> toKeyFn, @Nonnull BiFunctionEx<? super V, ? super T, ? extends V> updateFn) {
        return new SinkImpl<T>("mapWithUpdatingSink(" + mapName + ')', SinkProcessors.updateMapP(mapName, toKeyFn, updateFn), false, toKeyFn);
    }

    @Nonnull
    public static <T, K, V> Sink<T> mapWithUpdating(@Nonnull IMap<? super K, ? super V> map, @Nonnull FunctionEx<? super T, ? extends K> toKeyFn, @Nonnull BiFunctionEx<? super V, ? super T, ? extends V> updateFn) {
        return Sinks.mapWithUpdating(map.getName(), toKeyFn, updateFn);
    }

    @Nonnull
    public static <T, K, V> Sink<T> remoteMapWithUpdating(@Nonnull String mapName, @Nonnull ClientConfig clientConfig, @Nonnull FunctionEx<? super T, ? extends K> toKeyFn, @Nonnull BiFunctionEx<? super V, ? super T, ? extends V> updateFn) {
        return Sinks.fromProcessor("remoteMapWithUpdatingSink(" + mapName + ')', SinkProcessors.updateRemoteMapP(mapName, clientConfig, toKeyFn, updateFn));
    }

    @Nonnull
    public static <K, V, E extends Map.Entry<K, V>> Sink<E> mapWithUpdating(@Nonnull String mapName, @Nonnull BiFunctionEx<? super V, ? super E, ? extends V> updateFn) {
        return Sinks.mapWithUpdating(mapName, Functions.entryKey(), updateFn);
    }

    @Nonnull
    public static <K, V, E extends Map.Entry<K, V>> Sink<E> mapWithUpdating(@Nonnull IMap<? super K, ? super V> map, @Nonnull BiFunctionEx<? super V, ? super E, ? extends V> updateFn) {
        return Sinks.mapWithUpdating(map.getName(), updateFn);
    }

    @Nonnull
    public static <K, V, E extends Map.Entry<K, V>> Sink<E> remoteMapWithUpdating(@Nonnull String mapName, @Nonnull ClientConfig clientConfig, @Nonnull BiFunctionEx<? super V, ? super E, ? extends V> updateFn) {
        return Sinks.fromProcessor("remoteMapWithUpdatingSink(" + mapName + ')', SinkProcessors.updateRemoteMapP(mapName, clientConfig, (FunctionEx & Serializable)e -> e.getKey(), updateFn));
    }

    @Nonnull
    public static <E, K, V, R> Sink<E> mapWithEntryProcessor(@Nonnull String mapName, @Nonnull FunctionEx<? super E, ? extends K> toKeyFn, @Nonnull FunctionEx<? super E, ? extends EntryProcessor<K, V, R>> toEntryProcessorFn) {
        return Sinks.fromProcessor("mapWithEntryProcessorSink(" + mapName + ')', SinkProcessors.updateMapP(mapName, toKeyFn, toEntryProcessorFn));
    }

    @Nonnull
    public static <T, K, V, R> Sink<T> mapWithEntryProcessor(@Nonnull IMap<? super K, ? super V> map, @Nonnull FunctionEx<? super T, ? extends K> toKeyFn, @Nonnull FunctionEx<? super T, ? extends EntryProcessor<K, V, R>> toEntryProcessorFn) {
        return Sinks.mapWithEntryProcessor(map.getName(), toKeyFn, toEntryProcessorFn);
    }

    @Nonnull
    public static <E, K, V, R> Sink<E> remoteMapWithEntryProcessor(@Nonnull String mapName, @Nonnull ClientConfig clientConfig, @Nonnull FunctionEx<? super E, ? extends K> toKeyFn, @Nonnull FunctionEx<? super E, ? extends EntryProcessor<K, V, R>> toEntryProcessorFn) {
        return Sinks.fromProcessor("remoteMapWithEntryProcessorSink(" + mapName + ')', SinkProcessors.updateRemoteMapP(mapName, clientConfig, toKeyFn, toEntryProcessorFn));
    }

    @Nonnull
    public static <T extends Map.Entry> Sink<T> cache(@Nonnull String cacheName) {
        return new SinkImpl("cacheSink(" + cacheName + ')', SinkProcessors.writeCacheP(cacheName), false, (FunctionEx & Serializable)en -> en.getKey());
    }

    @Nonnull
    public static <T extends Map.Entry> Sink<T> remoteCache(@Nonnull String cacheName, @Nonnull ClientConfig clientConfig) {
        return Sinks.fromProcessor("remoteCacheSink(" + cacheName + ')', SinkProcessors.writeRemoteCacheP(cacheName, clientConfig));
    }

    @Nonnull
    public static <T> Sink<T> list(@Nonnull String listName) {
        return Sinks.fromProcessor("listSink(" + listName + ')', SinkProcessors.writeListP(listName));
    }

    @Nonnull
    public static <T> Sink<T> list(@Nonnull IList<? super T> list) {
        return Sinks.list(list.getName());
    }

    @Nonnull
    public static <T> Sink<T> remoteList(@Nonnull String listName, @Nonnull ClientConfig clientConfig) {
        return Sinks.fromProcessor("remoteListSink(" + listName + ')', SinkProcessors.writeRemoteListP(listName, clientConfig));
    }

    @Nonnull
    public static <T> Sink<T> reliableTopic(@Nonnull String reliableTopicName) {
        return SinkBuilder.sinkBuilder("reliableTopicSink(" + reliableTopicName + "))", (FunctionEx & Serializable)ctx -> ctx.jetInstance().getReliableTopic(reliableTopicName)).receiveFn(ITopic::publish).build();
    }

    @Nonnull
    public static <T> Sink<T> reliableTopic(@Nonnull ITopic<Object> reliableTopic) {
        return Sinks.reliableTopic(reliableTopic.getName());
    }

    @Nonnull
    public static <T> Sink<T> remoteReliableTopic(@Nonnull String reliableTopicName, @Nonnull ClientConfig clientConfig) {
        String clientXml = ImdgUtil.asXmlString(clientConfig);
        return SinkBuilder.sinkBuilder("reliableTopicSink(" + reliableTopicName + "))", (FunctionEx & Serializable)ctx -> HazelcastClient.newHazelcastClient((ClientConfig)ImdgUtil.asClientConfig(clientXml)).getReliableTopic(reliableTopicName)).receiveFn(ITopic::publish).build();
    }

    @Nonnull
    public static <T> Sink<T> socket(@Nonnull String host, int port, @Nonnull FunctionEx<? super T, ? extends String> toStringFn, @Nonnull Charset charset) {
        return Sinks.fromProcessor("socketSink(" + host + ':' + port + ')', SinkProcessors.writeSocketP(host, port, toStringFn, charset));
    }

    @Nonnull
    public static <T> Sink<T> socket(@Nonnull String host, int port, @Nonnull FunctionEx<? super T, ? extends String> toStringFn) {
        return Sinks.socket(host, port, toStringFn, StandardCharsets.UTF_8);
    }

    @Nonnull
    public static <T> Sink<T> socket(@Nonnull String host, int port) {
        return Sinks.socket(host, port, Object::toString);
    }

    @Nonnull
    public static <T> FileSinkBuilder<T> filesBuilder(@Nonnull String directoryName) {
        return new FileSinkBuilder(directoryName);
    }

    @Nonnull
    public static <T> Sink<T> files(@Nonnull String directoryName) {
        return Sinks.filesBuilder(directoryName).build();
    }

    @Nonnull
    public static <T> Sink<T> logger(@Nonnull FunctionEx<? super T, String> toStringFn) {
        return Sinks.fromProcessor("loggerSink", DiagnosticProcessors.writeLoggerP(toStringFn));
    }

    @Nonnull
    public static <T> Sink<T> logger() {
        return Sinks.logger(Object::toString);
    }

    @Nonnull
    public static <T> Sink<T> noop() {
        return Sinks.fromProcessor("noop", ProcessorMetaSupplier.preferLocalParallelismOne(Processors.noopP()));
    }

    @Nonnull
    public static <T> Sink<T> jmsQueue(@Nonnull String queueName, @Nonnull SupplierEx<ConnectionFactory> factorySupplier) {
        return Sinks.jmsQueueBuilder(factorySupplier).destinationName(queueName).build();
    }

    @Nonnull
    public static <T> JmsSinkBuilder<T> jmsQueueBuilder(@Nonnull SupplierEx<ConnectionFactory> factorySupplier) {
        return new JmsSinkBuilder(factorySupplier, false);
    }

    @Nonnull
    public static <T> Sink<T> jmsTopic(@Nonnull String topicName, @Nonnull SupplierEx<ConnectionFactory> factorySupplier) {
        return Sinks.jmsTopicBuilder(factorySupplier).destinationName(topicName).build();
    }

    @Nonnull
    public static <T> JmsSinkBuilder<T> jmsTopicBuilder(@Nonnull SupplierEx<ConnectionFactory> factorySupplier) {
        return new JmsSinkBuilder(factorySupplier, true);
    }

    @Nonnull
    public static <T> Sink<T> jdbc(@Nonnull String updateQuery, @Nonnull SupplierEx<? extends CommonDataSource> dataSourceSupplier, @Nonnull BiConsumerEx<PreparedStatement, T> bindFn) {
        return Sinks.jdbcBuilder().updateQuery(updateQuery).dataSourceSupplier(dataSourceSupplier).bindFn(bindFn).build();
    }

    @Nonnull
    public static <T> Sink<T> jdbc(@Nonnull String updateQuery, @Nonnull String jdbcUrl, @Nonnull BiConsumerEx<PreparedStatement, T> bindFn) {
        return Sinks.jdbcBuilder().updateQuery(updateQuery).jdbcUrl(jdbcUrl).bindFn(bindFn).build();
    }

    @Nonnull
    public static <T> JdbcSinkBuilder<T> jdbcBuilder() {
        return new JdbcSinkBuilder();
    }

    @Nonnull
    public static <T> Sink<T> observable(String name) {
        return Sinks.fromProcessor(String.format("observableSink(%s)", name), SinkProcessors.writeObservableP(name));
    }

    @Nonnull
    public static <T> Sink<T> observable(Observable<? super T> observable) {
        return Sinks.observable(observable.name());
    }
}

