/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.pipeline;

import com.hazelcast.function.BiConsumerEx;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.jet.core.processor.SinkProcessors;
import com.hazelcast.jet.impl.connector.DataSourceFromConnectionSupplier;
import com.hazelcast.jet.pipeline.Sink;
import com.hazelcast.jet.pipeline.Sinks;
import java.io.Serializable;
import java.sql.PreparedStatement;
import javax.annotation.Nonnull;
import javax.sql.CommonDataSource;

public class JdbcSinkBuilder<T> {
    private String updateQuery;
    private BiConsumerEx<PreparedStatement, T> bindFn;
    private SupplierEx<? extends CommonDataSource> dataSourceSupplier;
    private boolean exactlyOnce = true;

    JdbcSinkBuilder() {
    }

    @Nonnull
    public JdbcSinkBuilder<T> updateQuery(@Nonnull String updateQuery) {
        this.updateQuery = updateQuery;
        return this;
    }

    @Nonnull
    public JdbcSinkBuilder<T> bindFn(@Nonnull BiConsumerEx<PreparedStatement, T> bindFn) {
        this.bindFn = bindFn;
        return this;
    }

    @Nonnull
    public JdbcSinkBuilder<T> jdbcUrl(String connectionUrl) {
        this.dataSourceSupplier = (SupplierEx & Serializable)() -> new DataSourceFromConnectionSupplier(connectionUrl);
        return this;
    }

    @Nonnull
    public JdbcSinkBuilder<T> dataSourceSupplier(SupplierEx<? extends CommonDataSource> dataSourceSupplier) {
        this.dataSourceSupplier = dataSourceSupplier;
        return this;
    }

    @Nonnull
    public JdbcSinkBuilder<T> exactlyOnce(boolean enabled) {
        this.exactlyOnce = enabled;
        return this;
    }

    @Nonnull
    public Sink<T> build() {
        if (this.dataSourceSupplier == null) {
            throw new IllegalStateException("Neither jdbcUrl() nor dataSourceSupplier() set");
        }
        return Sinks.fromProcessor("jdbcSink", SinkProcessors.writeJdbcP(this.updateQuery, this.dataSourceSupplier, this.bindFn, this.exactlyOnce));
    }
}

