/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.execution.init;

import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.nio.serialization.SerializerHook;
import com.hazelcast.nio.serialization.StreamSerializer;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;

public final class CustomClassLoadedObject {
    protected final Serializable object;

    private CustomClassLoadedObject(Serializable object) {
        this.object = object;
    }

    public static void write(ObjectDataOutput out, Serializable object) throws IOException {
        out.writeObject((Object)new CustomClassLoadedObject(object));
    }

    public static <T> T read(ObjectDataInput input) throws IOException {
        return (T)((CustomClassLoadedObject)input.readObject()).object;
    }

    public static <T> T deserializeWithCustomClassLoader(SerializationService serializationService, ClassLoader cl, Data data) {
        ClassLoader previous = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(cl);
        try {
            Object object = serializationService.toObject((Object)data);
            return (T)object;
        }
        catch (HazelcastSerializationException e) {
            throw ExceptionUtil.handleSerializedLambdaCce(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(previous);
        }
    }

    public static final class Serializer
    implements StreamSerializer<CustomClassLoadedObject> {
        @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST", "OS_OPEN_STREAM"})
        public void write(ObjectDataOutput out, CustomClassLoadedObject object) throws IOException {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)out);
            objectOutputStream.writeObject(object.object);
            objectOutputStream.flush();
        }

        @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST", "OS_OPEN_STREAM"})
        public CustomClassLoadedObject read(ObjectDataInput in) throws IOException {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            ObjectInputStream objectInputStream = IOUtil.newObjectInputStream((ClassLoader)cl, null, (InputStream)((InputStream)in));
            try {
                return new CustomClassLoadedObject((Serializable)objectInputStream.readObject());
            }
            catch (ClassNotFoundException e) {
                throw new HazelcastSerializationException((Throwable)e);
            }
        }

        public int getTypeId() {
            return -301;
        }
    }

    public static final class Hook
    implements SerializerHook<CustomClassLoadedObject> {
        public Class<CustomClassLoadedObject> getSerializationType() {
            return CustomClassLoadedObject.class;
        }

        public Serializer createSerializer() {
            return new Serializer();
        }

        public boolean isOverwritable() {
            return false;
        }
    }
}

