/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.connector;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.jet.core.Inbox;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.impl.connector.AbstractHazelcastConnectorSupplier;
import com.hazelcast.jet.impl.connector.AsyncHazelcastWriterP;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.IMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class UpdateMapWithEntryProcessorP<T, K, V, R>
extends AsyncHazelcastWriterP {
    private final IMap<K, V> map;
    private final FunctionEx<? super T, ? extends K> toKeyFn;
    private final FunctionEx<? super T, ? extends EntryProcessor<K, V, R>> toEntryProcessorFn;

    UpdateMapWithEntryProcessorP(@Nonnull HazelcastInstance instance, int maxParallelAsyncOps, @Nonnull String name, @Nonnull FunctionEx<? super T, ? extends K> toKeyFn, @Nonnull FunctionEx<? super T, ? extends EntryProcessor<K, V, R>> toEntryProcessorFn) {
        super(instance, maxParallelAsyncOps);
        this.map = instance.getMap(name);
        this.toKeyFn = toKeyFn;
        this.toEntryProcessorFn = toEntryProcessorFn;
    }

    @Override
    protected void processInternal(Inbox inbox) {
        Object object;
        for (int permits = this.tryAcquirePermits(inbox.size()); permits > 0 && (object = inbox.peek()) != null; --permits) {
            Object item = object;
            EntryProcessor entryProcessor = (EntryProcessor)this.toEntryProcessorFn.apply(item);
            Object key = this.toKeyFn.apply(item);
            this.setCallback(this.map.submitToKey(key, entryProcessor));
            inbox.remove();
        }
    }

    static final class Supplier<T, K, V, R>
    extends AbstractHazelcastConnectorSupplier {
        static final long serialVersionUID = 1L;
        private final String name;
        private final FunctionEx<? super T, ? extends K> toKeyFn;
        private final FunctionEx<? super T, ? extends EntryProcessor<K, V, R>> toEntryProcessorFn;

        Supplier(@Nonnull String name, @Nullable String clientXml, @Nonnull FunctionEx<? super T, ? extends K> toKeyFn, @Nonnull FunctionEx<? super T, ? extends EntryProcessor<K, V, R>> toEntryProcessorFn) {
            super(clientXml);
            this.name = name;
            this.toKeyFn = toKeyFn;
            this.toEntryProcessorFn = toEntryProcessorFn;
        }

        @Override
        protected Processor createProcessor(HazelcastInstance instance, SerializationService serializationService) {
            return new UpdateMapWithEntryProcessorP(instance, 1000, this.name, this.toKeyFn, this.toEntryProcessorFn);
        }
    }
}

