/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.client.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.DataCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.internal.serialization.Data;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

public final class JetSubmitJobCodec {
    public static final int REQUEST_MESSAGE_TYPE = 16646400;
    public static final int RESPONSE_MESSAGE_TYPE = 16646401;
    private static final int REQUEST_JOB_ID_FIELD_OFFSET = 16;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 24;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 13;

    private JetSubmitJobCodec() {
    }

    public static ClientMessage encodeRequest(long jobId, Data dag, Data jobConfig) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(false);
        clientMessage.setOperationName("Jet.SubmitJob");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[24], 49152);
        FixedSizeTypesCodec.encodeInt((byte[])initialFrame.content, (int)0, (int)16646400);
        FixedSizeTypesCodec.encodeLong((byte[])initialFrame.content, (int)16, (long)jobId);
        clientMessage.add(initialFrame);
        DataCodec.encode((ClientMessage)clientMessage, (Data)dag);
        DataCodec.encode((ClientMessage)clientMessage, (Data)jobConfig);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        request.jobId = FixedSizeTypesCodec.decodeLong((byte[])initialFrame.content, (int)16);
        request.dag = DataCodec.decode((ClientMessage.ForwardFrameIterator)iterator);
        request.jobConfig = DataCodec.decode((ClientMessage.ForwardFrameIterator)iterator);
        return request;
    }

    public static ClientMessage encodeResponse() {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[13], 49152);
        FixedSizeTypesCodec.encodeInt((byte[])initialFrame.content, (int)0, (int)16646401);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        ResponseParameters response = new ResponseParameters();
        iterator.next();
        return response;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class ResponseParameters {
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public long jobId;
        public Data dag;
        public Data jobConfig;
    }
}

