/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.client.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.DataCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.internal.serialization.Data;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

public final class JetGetJobMetricsCodec {
    public static final int REQUEST_MESSAGE_TYPE = 16649472;
    public static final int RESPONSE_MESSAGE_TYPE = 16649473;
    private static final int REQUEST_JOB_ID_FIELD_OFFSET = 16;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 24;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 13;

    private JetGetJobMetricsCodec() {
    }

    public static ClientMessage encodeRequest(long jobId) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(true);
        clientMessage.setOperationName("Jet.GetJobMetrics");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[24], 49152);
        FixedSizeTypesCodec.encodeInt((byte[])initialFrame.content, (int)0, (int)16649472);
        FixedSizeTypesCodec.encodeLong((byte[])initialFrame.content, (int)16, (long)jobId);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        request.jobId = FixedSizeTypesCodec.decodeLong((byte[])initialFrame.content, (int)16);
        return request;
    }

    public static ClientMessage encodeResponse(Data response) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[13], 49152);
        FixedSizeTypesCodec.encodeInt((byte[])initialFrame.content, (int)0, (int)16649473);
        clientMessage.add(initialFrame);
        DataCodec.encode((ClientMessage)clientMessage, (Data)response);
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        ResponseParameters response = new ResponseParameters();
        iterator.next();
        response.response = DataCodec.decode((ClientMessage.ForwardFrameIterator)iterator);
        return response;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class ResponseParameters {
        public Data response;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public long jobId;
    }
}

