/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet;

import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.impl.JobRepository;
import com.hazelcast.jet.impl.SnapshotValidationRecord;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class JobStateSnapshot {
    private final JetInstance instance;
    private final String name;
    private final SnapshotValidationRecord snapshotValidationRecord;

    JobStateSnapshot(@Nonnull JetInstance instance, @Nonnull String name, @Nonnull SnapshotValidationRecord record) {
        this.instance = instance;
        this.name = name;
        this.snapshotValidationRecord = record;
    }

    @Nonnull
    public String name() {
        return this.name;
    }

    public long creationTime() {
        return this.snapshotValidationRecord.creationTime();
    }

    public long jobId() {
        return this.snapshotValidationRecord.jobId();
    }

    @Nullable
    public String jobName() {
        return this.snapshotValidationRecord.jobName();
    }

    public long payloadSize() {
        return this.snapshotValidationRecord.numBytes();
    }

    @Nonnull
    public String dagJsonString() {
        return this.snapshotValidationRecord.dagJsonString();
    }

    public void destroy() {
        this.instance.getMap(JobRepository.exportedSnapshotMapName(this.name)).destroy();
        this.instance.getMap("__jet.exportedSnapshotsCache").delete((Object)this.name);
    }
}

