/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet;

import com.hazelcast.cluster.Cluster;
import com.hazelcast.collection.IList;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.internal.util.UuidUtil;
import com.hazelcast.jet.JetCacheManager;
import com.hazelcast.jet.Job;
import com.hazelcast.jet.JobStateSnapshot;
import com.hazelcast.jet.Observable;
import com.hazelcast.jet.config.JetConfig;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.core.DAG;
import com.hazelcast.jet.impl.AbstractJetInstance;
import com.hazelcast.jet.impl.JobRepository;
import com.hazelcast.jet.impl.SnapshotValidationRecord;
import com.hazelcast.jet.impl.pipeline.PipelineImpl;
import com.hazelcast.jet.pipeline.Pipeline;
import com.hazelcast.map.IMap;
import com.hazelcast.replicatedmap.ReplicatedMap;
import com.hazelcast.topic.ITopic;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface JetInstance {
    @Nonnull
    public String getName();

    @Nonnull
    public HazelcastInstance getHazelcastInstance();

    @Nonnull
    public Cluster getCluster();

    @Nonnull
    public JetConfig getConfig();

    @Nonnull
    default public Job newJob(@Nonnull DAG dag) {
        return this.newJob(dag, new JobConfig());
    }

    @Nonnull
    default public Job newJob(@Nonnull Pipeline pipeline) {
        return this.newJob(pipeline, new JobConfig());
    }

    @Nonnull
    public Job newJob(@Nonnull DAG var1, @Nonnull JobConfig var2);

    @Nonnull
    default public Job newJob(@Nonnull Pipeline pipeline, @Nonnull JobConfig config) {
        return this.newJob(pipeline.toDag(), config.attachAll(((PipelineImpl)pipeline).attachedFiles()));
    }

    @Nonnull
    public Job newJobIfAbsent(@Nonnull DAG var1, @Nonnull JobConfig var2);

    @Nonnull
    default public Job newJobIfAbsent(@Nonnull Pipeline pipeline, @Nonnull JobConfig config) {
        return this.newJobIfAbsent(pipeline.toDag(), config.attachAll(((PipelineImpl)pipeline).attachedFiles()));
    }

    @Nonnull
    public List<Job> getJobs();

    @Nullable
    public Job getJob(long var1);

    @Nonnull
    public List<Job> getJobs(@Nonnull String var1);

    @Nullable
    default public Job getJob(@Nonnull String name) {
        return this.getJobs(name).stream().findFirst().orElse(null);
    }

    @Nullable
    default public JobStateSnapshot getJobStateSnapshot(@Nonnull String name) {
        String mapName = JobRepository.exportedSnapshotMapName(name);
        if (!((AbstractJetInstance)this).existsDistributedObject("hz:impl:mapService", mapName)) {
            return null;
        }
        IMap map = this.getMap(mapName);
        Object validationRecord = map.get((Object)SnapshotValidationRecord.KEY);
        if (validationRecord instanceof SnapshotValidationRecord) {
            this.getMap("__jet.exportedSnapshotsCache").set((Object)name, validationRecord);
            return new JobStateSnapshot(this, name, (SnapshotValidationRecord)validationRecord);
        }
        return null;
    }

    @Nonnull
    default public Collection<JobStateSnapshot> getJobStateSnapshots() {
        return this.getHazelcastInstance().getMap("__jet.exportedSnapshotsCache").entrySet().stream().map(entry -> new JobStateSnapshot(this, (String)entry.getKey(), (SnapshotValidationRecord)entry.getValue())).collect(Collectors.toList());
    }

    @Nonnull
    public <K, V> IMap<K, V> getMap(@Nonnull String var1);

    @Nonnull
    public <K, V> ReplicatedMap<K, V> getReplicatedMap(@Nonnull String var1);

    @Nonnull
    public <E> IList<E> getList(@Nonnull String var1);

    @Nonnull
    public <E> ITopic<E> getReliableTopic(@Nonnull String var1);

    @Nonnull
    public JetCacheManager getCacheManager();

    @Nonnull
    public <T> Observable<T> getObservable(@Nonnull String var1);

    @Nonnull
    default public <T> Observable<T> newObservable() {
        return this.getObservable(UuidUtil.newUnsecureUuidString());
    }

    @Nonnull
    public Collection<Observable<?>> getObservables();

    public void shutdown();
}

