/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.pipeline;

import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.jet.impl.connector.WriteJmsP;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.pipeline.Sink;
import com.hazelcast.jet.pipeline.Sinks;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Message;
import javax.jms.Session;

public final class JmsSinkBuilder<T> {
    private final SupplierEx<ConnectionFactory> factorySupplier;
    private final boolean isTopic;
    private FunctionEx<ConnectionFactory, Connection> connectionFn;
    private BiFunctionEx<Session, T, Message> messageFn;
    private String username;
    private String password;
    private String destinationName;

    JmsSinkBuilder(@Nonnull SupplierEx<ConnectionFactory> factorySupplier, boolean isTopic) {
        Util.checkSerializable(factorySupplier, "factorySupplier");
        this.factorySupplier = factorySupplier;
        this.isTopic = isTopic;
    }

    public JmsSinkBuilder<T> connectionParams(String username, String password) {
        this.username = username;
        this.password = password;
        return this;
    }

    public JmsSinkBuilder<T> connectionFn(@Nonnull FunctionEx<ConnectionFactory, Connection> connectionFn) {
        Util.checkSerializable(connectionFn, "connectionFn");
        this.connectionFn = connectionFn;
        return this;
    }

    public JmsSinkBuilder<T> destinationName(@Nonnull String destinationName) {
        this.destinationName = destinationName;
        return this;
    }

    public JmsSinkBuilder<T> messageFn(BiFunctionEx<Session, T, Message> messageFn) {
        Util.checkSerializable(messageFn, "messageFn");
        this.messageFn = messageFn;
        return this;
    }

    public Sink<T> build() {
        String usernameLocal = this.username;
        String passwordLocal = this.password;
        Preconditions.checkNotNull((Object)this.destinationName);
        if (this.connectionFn == null) {
            this.connectionFn = (FunctionEx & Serializable)factory -> usernameLocal != null || passwordLocal != null ? factory.createConnection(usernameLocal, passwordLocal) : factory.createConnection();
        }
        if (this.messageFn == null) {
            this.messageFn = (BiFunctionEx & Serializable)(session, item) -> item instanceof Message ? (Message)item : session.createTextMessage(item.toString());
        }
        FunctionEx<ConnectionFactory, Connection> connectionFnLocal = this.connectionFn;
        SupplierEx<ConnectionFactory> factorySupplierLocal = this.factorySupplier;
        SupplierEx & Serializable newConnectionFn = (SupplierEx & Serializable)() -> (Connection)connectionFnLocal.apply(factorySupplierLocal.get());
        return Sinks.fromProcessor(this.sinkName(), WriteJmsP.supplier(this.destinationName, (SupplierEx<? extends Connection>)newConnectionFn, this.messageFn, this.isTopic));
    }

    private String sinkName() {
        return String.format("jms%sSink(%s)", this.isTopic ? "Topic" : "Queue", this.destinationName);
    }
}

