/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.pipeline;

import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.jet.datamodel.ItemsByTag;
import com.hazelcast.jet.datamodel.Tag;
import com.hazelcast.jet.impl.pipeline.AbstractStage;
import com.hazelcast.jet.impl.pipeline.ComputeStageImplBase;
import com.hazelcast.jet.impl.pipeline.FunctionAdapter;
import com.hazelcast.jet.impl.pipeline.PipelineImpl;
import com.hazelcast.jet.impl.pipeline.transform.HashJoinTransform;
import com.hazelcast.jet.impl.pipeline.transform.Transform;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.pipeline.BatchStage;
import com.hazelcast.jet.pipeline.GeneralStage;
import com.hazelcast.jet.pipeline.JoinClause;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class GeneralHashJoinBuilder<T0> {
    private final Transform transform0;
    private final PipelineImpl pipelineImpl;
    private final FunctionAdapter fnAdapter;
    private final CreateOutStageFn<T0> createOutStageFn;
    private final Map<Tag<?>, TransformAndClause> clauses = new HashMap();

    GeneralHashJoinBuilder(GeneralStage<T0> stage0, CreateOutStageFn<T0> createOutStageFn) {
        this.transform0 = AbstractStage.transformOf(stage0);
        this.pipelineImpl = (PipelineImpl)stage0.getPipeline();
        this.createOutStageFn = createOutStageFn;
        this.fnAdapter = ((ComputeStageImplBase)((Object)stage0)).fnAdapter;
    }

    public <K, T1_IN, T1> Tag<T1> add(BatchStage<T1_IN> stage, JoinClause<K, T0, T1_IN, T1> joinClause) {
        Tag tag = Tag.tag(this.clauses.size());
        this.clauses.put(tag, new TransformAndClause<K, T0, T1_IN, T1>(stage, joinClause));
        return tag;
    }

    <R> GeneralStage<R> build0(BiFunctionEx<T0, ItemsByTag, R> mapToOutputFn) {
        Util.checkSerializable(mapToOutputFn, "mapToOutputFn");
        List orderedClauses = this.clauses.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).collect(Collectors.toList());
        List<Transform> upstream = Stream.concat(Stream.of(this.transform0), orderedClauses.stream().map(e -> ((TransformAndClause)e.getValue()).transform())).collect(Collectors.toList());
        Stream<JoinClause> joinClauses = orderedClauses.stream().map(e -> ((TransformAndClause)e.getValue()).clause()).map(this.fnAdapter::adaptJoinClause);
        HashJoinTransform hashJoinTransform = new HashJoinTransform(upstream, joinClauses.collect(Collectors.toList()), orderedClauses.stream().map(Map.Entry::getKey).collect(Collectors.toList()), this.fnAdapter.adaptHashJoinOutputFn(mapToOutputFn));
        this.pipelineImpl.connect(upstream, hashJoinTransform);
        return this.createOutStageFn.get(hashJoinTransform, this.fnAdapter, this.pipelineImpl);
    }

    private static class TransformAndClause<K, E0, T1, T1_OUT> {
        private final Transform transform;
        private final JoinClause<K, E0, T1, T1_OUT> joinClause;

        TransformAndClause(GeneralStage<T1> stage, JoinClause<K, E0, T1, T1_OUT> joinClause) {
            this.transform = AbstractStage.transformOf(stage);
            this.joinClause = joinClause;
        }

        Transform transform() {
            return this.transform;
        }

        JoinClause<K, E0, T1, T1_OUT> clause() {
            return this.joinClause;
        }
    }

    @FunctionalInterface
    static interface CreateOutStageFn<T0> {
        public <R> GeneralStage<R> get(HashJoinTransform<T0, R> var1, FunctionAdapter var2, PipelineImpl var3);
    }
}

