/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.processor;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.aggregate.AggregateOperation;
import com.hazelcast.jet.aggregate.AggregateOperation1;
import com.hazelcast.jet.core.AbstractProcessor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;

public class GroupP<K, A, R, OUT>
extends AbstractProcessor {
    @Nonnull
    private final List<FunctionEx<?, ? extends K>> groupKeyFns;
    @Nonnull
    private final AggregateOperation<A, R> aggrOp;
    private final Map<K, A> keyToAcc = new HashMap<K, A>();
    private Traverser<OUT> resultTraverser;
    private final BiFunction<? super K, ? super R, OUT> mapToOutputFn;

    public GroupP(@Nonnull List<FunctionEx<?, ? extends K>> groupKeyFns, @Nonnull AggregateOperation<A, R> aggrOp, @Nonnull BiFunction<? super K, ? super R, OUT> mapToOutputFn) {
        Preconditions.checkTrue((groupKeyFns.size() == aggrOp.arity() ? 1 : 0) != 0, (String)(groupKeyFns.size() + " key functions provided for " + aggrOp.arity() + "-arity aggregate operation"));
        this.groupKeyFns = groupKeyFns;
        this.aggrOp = aggrOp;
        this.mapToOutputFn = mapToOutputFn;
    }

    public <T> GroupP(@Nonnull FunctionEx<? super T, ? extends K> groupKeyFn, @Nonnull AggregateOperation1<? super T, A, R> aggrOp, @Nonnull BiFunction<? super K, ? super R, OUT> mapToOutputFn) {
        this(Collections.singletonList(groupKeyFn), aggrOp, mapToOutputFn);
    }

    @Override
    protected boolean tryProcess(int ordinal, @Nonnull Object item) {
        Function keyFn = (Function)this.groupKeyFns.get(ordinal);
        Object key = keyFn.apply(item);
        Object acc = this.keyToAcc.computeIfAbsent(key, k -> this.aggrOp.createFn().get());
        this.aggrOp.accumulateFn(ordinal).accept(acc, item);
        return true;
    }

    @Override
    public boolean complete() {
        if (this.resultTraverser == null) {
            this.resultTraverser = new ResultTraverser().map(e -> this.mapToOutputFn.apply(e.getKey(), this.aggrOp.finishFn().apply(e.getValue())));
        }
        return this.emitFromTraverser(this.resultTraverser);
    }

    private class ResultTraverser
    implements Traverser<Map.Entry<K, A>> {
        private final Iterator<Map.Entry<K, A>> iter;

        private ResultTraverser() {
            this.iter = GroupP.this.keyToAcc.entrySet().iterator();
        }

        @Override
        public Map.Entry<K, A> next() {
            if (!this.iter.hasNext()) {
                return null;
            }
            try {
                Map.Entry entry = this.iter.next();
                return entry;
            }
            finally {
                this.iter.remove();
            }
        }
    }
}

