/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.pipeline;

import com.hazelcast.jet.impl.pipeline.PipelineImpl;
import com.hazelcast.jet.impl.pipeline.transform.Transform;
import com.hazelcast.jet.pipeline.GeneralStage;
import com.hazelcast.jet.pipeline.Pipeline;
import com.hazelcast.jet.pipeline.SinkStage;
import com.hazelcast.jet.pipeline.Stage;
import java.util.ArrayList;
import java.util.Collections;
import javax.annotation.Nonnull;

public abstract class AbstractStage
implements Stage {
    final PipelineImpl pipelineImpl;
    final Transform transform;

    AbstractStage(Transform transform, boolean acceptsDownstream, PipelineImpl pipelineImpl) {
        this.transform = transform;
        this.pipelineImpl = pipelineImpl;
        pipelineImpl.register(transform, acceptsDownstream ? new ArrayList() : Collections.emptyList());
    }

    public static Transform transformOf(GeneralStage stage) {
        return ((AbstractStage)((Object)stage)).transform;
    }

    public static Transform transformOf(SinkStage stage) {
        return ((AbstractStage)((Object)stage)).transform;
    }

    @Override
    public Pipeline getPipeline() {
        return this.pipelineImpl;
    }

    @Override
    @Nonnull
    public Stage setLocalParallelism(int localParallelism) {
        this.transform.localParallelism(localParallelism);
        return this;
    }

    @Override
    @Nonnull
    public Stage setName(@Nonnull String name) {
        this.transform.setName(name);
        return this;
    }

    @Override
    @Nonnull
    public String name() {
        return this.transform.name();
    }

    public String toString() {
        return String.valueOf(this.transform);
    }
}

