/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.operation;

import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.Member;
import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.collectors.MetricsCollector;
import com.hazelcast.internal.metrics.impl.MetricsCompressor;
import com.hazelcast.jet.Util;
import com.hazelcast.jet.impl.JetService;
import com.hazelcast.jet.impl.JobExecutionService;
import com.hazelcast.jet.impl.JobMetricsUtil;
import com.hazelcast.jet.impl.execution.init.JetInitDataSerializerHook;
import com.hazelcast.jet.impl.metrics.RawJobMetrics;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.operationservice.ExceptionAction;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.io.IOException;
import java.util.Objects;
import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;

public class CompleteExecutionOperation
extends Operation
implements IdentifiedDataSerializable {
    private long executionId;
    private boolean collectMetrics;
    private Throwable error;
    private RawJobMetrics response;

    public CompleteExecutionOperation() {
    }

    public CompleteExecutionOperation(long executionId, boolean collectMetrics, Throwable error) {
        this.executionId = executionId;
        this.collectMetrics = collectMetrics;
        this.error = error;
    }

    public void run() {
        ILogger logger = this.getLogger();
        JetService service = (JetService)this.getService();
        Address callerAddress = this.getCallerAddress();
        logger.fine("Completing execution " + Util.idToString(this.executionId) + " from caller " + callerAddress + ", error=" + this.error);
        NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
        Address masterAddress = this.getNodeEngine().getMasterAddress();
        if (!callerAddress.equals((Object)masterAddress)) {
            throw new IllegalStateException("Caller " + callerAddress + " cannot complete execution " + Util.idToString(this.executionId) + " because it is not master. Master is: " + masterAddress);
        }
        JobExecutionService jobExecutionService = service.getJobExecutionService();
        jobExecutionService.beforeCompleteExecution(this.executionId);
        if (this.collectMetrics) {
            JobMetricsCollector metricsRenderer = new JobMetricsCollector(this.executionId, (Member)nodeEngine.getLocalMember(), logger);
            nodeEngine.getMetricsRegistry().collect((MetricsCollector)metricsRenderer);
            this.response = metricsRenderer.getMetrics();
        } else {
            this.response = RawJobMetrics.empty();
        }
        jobExecutionService.completeExecution(this.executionId, this.error);
    }

    public Object getResponse() {
        return this.response;
    }

    public ExceptionAction onInvocationException(Throwable throwable) {
        return ExceptionUtil.isRestartableException(throwable) ? ExceptionAction.THROW_EXCEPTION : super.onInvocationException(throwable);
    }

    public int getFactoryId() {
        return JetInitDataSerializerHook.FACTORY_ID;
    }

    public int getClassId() {
        return 7;
    }

    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.executionId);
        out.writeBoolean(this.collectMetrics);
        out.writeObject((Object)this.error);
    }

    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.executionId = in.readLong();
        this.collectMetrics = in.readBoolean();
        this.error = (Throwable)in.readObject();
    }

    private static class JobMetricsCollector
    implements MetricsCollector {
        private final Long executionIdOfInterest;
        private final MetricsCompressor compressor;
        private final ILogger logger;
        private final UnaryOperator<MetricDescriptor> addPrefixFn;

        JobMetricsCollector(long executionId, @Nonnull Member member, @Nonnull ILogger logger) {
            Objects.requireNonNull(member, "member");
            this.logger = Objects.requireNonNull(logger, "logger");
            this.executionIdOfInterest = executionId;
            this.addPrefixFn = JobMetricsUtil.addMemberPrefixFn(member);
            this.compressor = new MetricsCompressor();
        }

        public void collectLong(MetricDescriptor descriptor, long value) {
            Long executionId = JobMetricsUtil.getExecutionIdFromMetricsDescriptor(descriptor);
            if (this.executionIdOfInterest.equals(executionId)) {
                this.compressor.addLong((MetricDescriptor)this.addPrefixFn.apply(descriptor), value);
            }
        }

        public void collectDouble(MetricDescriptor descriptor, double value) {
            Long executionId = JobMetricsUtil.getExecutionIdFromMetricsDescriptor(descriptor);
            if (this.executionIdOfInterest.equals(executionId)) {
                this.compressor.addDouble((MetricDescriptor)this.addPrefixFn.apply(descriptor), value);
            }
        }

        public void collectException(MetricDescriptor descriptor, Exception e) {
            Long executionId = JobMetricsUtil.getExecutionIdFromMetricsDescriptor(descriptor);
            if (this.executionIdOfInterest.equals(executionId)) {
                this.logger.warning("Exception when rendering job metrics: " + e, (Throwable)e);
            }
        }

        public void collectNoValue(MetricDescriptor descriptor) {
        }

        @Nonnull
        public RawJobMetrics getMetrics() {
            return RawJobMetrics.of(this.compressor.getBlobAndReset());
        }
    }
}

