/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.connector;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.RestartableException;
import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.Traversers;
import com.hazelcast.jet.Util;
import com.hazelcast.jet.config.ProcessingGuarantee;
import com.hazelcast.jet.core.AbstractProcessor;
import com.hazelcast.jet.core.BroadcastKey;
import com.hazelcast.jet.core.EventTimeMapper;
import com.hazelcast.jet.core.EventTimePolicy;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.jet.impl.util.LoggingUtil;
import com.hazelcast.jet.pipeline.JmsSourceBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Session;

public class StreamJmsP<T>
extends AbstractProcessor {
    public static final int PREFERRED_LOCAL_PARALLELISM = 1;
    private static final BroadcastKey<String> SEEN_IDS_KEY = BroadcastKey.broadcastKey("seen");
    private static final long RESTORED_IDS_TTL = TimeUnit.MINUTES.toNanos(1L);
    private final Connection connection;
    private final FunctionEx<? super Session, ? extends MessageConsumer> consumerFn;
    private final FunctionEx<? super Message, ? extends T> projectionFn;
    private final FunctionEx<? super Message, ?> messageIdFn;
    private final EventTimeMapper<? super T> eventTimeMapper;
    private final ProcessingGuarantee guarantee;
    private final Set<Object> seenIds;
    private Set<Object> restoredIds;
    private long restoredIdsExpiration = Long.MAX_VALUE;
    private Session session;
    private MessageConsumer consumer;
    private Traverser<Object> pendingTraverser = Traversers.empty();
    private boolean snapshotInProgress;
    private Traverser<Map.Entry<BroadcastKey<String>, Set<Object>>> snapshotTraverser;

    StreamJmsP(Connection connection, FunctionEx<? super Session, ? extends MessageConsumer> consumerFn, FunctionEx<? super Message, ?> messageIdFn, FunctionEx<? super Message, ? extends T> projectionFn, EventTimePolicy<? super T> eventTimePolicy, ProcessingGuarantee guarantee) {
        this.connection = connection;
        this.consumerFn = consumerFn;
        this.messageIdFn = messageIdFn;
        this.projectionFn = projectionFn;
        this.guarantee = guarantee;
        this.eventTimeMapper = new EventTimeMapper<T>(eventTimePolicy);
        this.eventTimeMapper.addPartitions(1);
        this.seenIds = guarantee == ProcessingGuarantee.EXACTLY_ONCE ? new HashSet() : Collections.emptySet();
        this.restoredIds = guarantee == ProcessingGuarantee.EXACTLY_ONCE ? new HashSet() : Collections.emptySet();
    }

    @Override
    public boolean isCooperative() {
        return this.guarantee == ProcessingGuarantee.NONE;
    }

    @Override
    protected void init(@Nonnull Processor.Context context) throws JMSException {
        this.session = this.connection.createSession(this.guarantee != ProcessingGuarantee.NONE, 3);
        this.consumer = (MessageConsumer)this.consumerFn.apply((Object)this.session);
    }

    private static long handleJmsTimestamp(Message msg) {
        try {
            return msg.getJMSTimestamp() == 0L ? Long.MIN_VALUE : msg.getJMSTimestamp();
        }
        catch (JMSException e) {
            throw ExceptionUtil.sneakyThrow(e);
        }
    }

    @Override
    public boolean complete() {
        if (this.snapshotInProgress) {
            return false;
        }
        while (this.emitFromTraverser(this.pendingTraverser)) {
            try {
                Message t = this.consumer.receiveNoWait();
                if (t == null) {
                    this.pendingTraverser = this.eventTimeMapper.flatMapIdle();
                    break;
                }
                if (this.guarantee == ProcessingGuarantee.EXACTLY_ONCE) {
                    if (this.restoredIdsExpiration == Long.MAX_VALUE) {
                        this.restoredIdsExpiration = System.nanoTime() + RESTORED_IDS_TTL;
                    } else if (!this.restoredIds.isEmpty() && this.restoredIdsExpiration <= System.nanoTime()) {
                        this.restoredIds = Collections.emptySet();
                    }
                    Object msgId = this.messageIdFn.apply((Object)t);
                    if (msgId == null) {
                        throw new JetException("Received a message without an ID. All messages must have an ID, you can specify an extracting function using " + JmsSourceBuilder.class.getSimpleName() + ".messageIdFn()");
                    }
                    this.seenIds.add(msgId);
                    if (this.restoredIds.remove(msgId)) continue;
                }
                this.pendingTraverser = this.eventTimeMapper.flatMapEvent(this.projectionFn.apply((Object)t), 0, StreamJmsP.handleJmsTimestamp(t));
            }
            catch (JMSException e) {
                throw ExceptionUtil.sneakyThrow(e);
            }
        }
        return false;
    }

    @Override
    public boolean snapshotCommitPrepare() {
        if (!this.emitFromTraverser(this.pendingTraverser)) {
            return false;
        }
        boolean bl = this.snapshotInProgress = this.guarantee != ProcessingGuarantee.NONE;
        if (this.guarantee != ProcessingGuarantee.EXACTLY_ONCE) {
            return true;
        }
        if (this.snapshotTraverser == null) {
            this.snapshotTraverser = Traversers.traverseItems(this.seenIds, this.restoredIds).filter(ids -> !ids.isEmpty()).map(ids -> Util.entry(SEEN_IDS_KEY, ids)).onFirstNull(() -> {
                this.snapshotTraverser = null;
            });
            LoggingUtil.logFine(this.getLogger(), "Saved %d message(s) IDs to snapshot", this.seenIds.size());
        }
        return this.emitFromTraverserToSnapshot(this.snapshotTraverser);
    }

    @Override
    public boolean snapshotCommitFinish(boolean success) {
        if (this.guarantee == ProcessingGuarantee.NONE) {
            return true;
        }
        if (success) {
            try {
                this.session.commit();
                this.getLogger().fine("Session committed");
            }
            catch (JMSException e) {
                throw ExceptionUtil.sneakyThrow(e);
            }
            this.seenIds.clear();
        } else if (this.guarantee == ProcessingGuarantee.EXACTLY_ONCE) {
            throw new RestartableException("the snapshot failed");
        }
        this.snapshotInProgress = false;
        return true;
    }

    @Override
    protected void restoreFromSnapshot(@Nonnull Object key, @Nonnull Object value) {
        if (!SEEN_IDS_KEY.equals(key)) {
            throw new RuntimeException("Unexpected key received from snapshot: " + key);
        }
        if (this.guarantee == ProcessingGuarantee.EXACTLY_ONCE) {
            Set castValue = (Set)value;
            this.restoredIds.addAll(castValue);
            LoggingUtil.logFine(this.getLogger(), "Restored %d seen IDs from snapshot", castValue.size());
        }
    }

    @Override
    public void close() throws Exception {
        if (this.consumer != null) {
            this.consumer.close();
        }
        if (this.session != null) {
            this.session.close();
        }
    }

    public static final class Supplier<T>
    implements ProcessorSupplier {
        static final long serialVersionUID = 1L;
        private final SupplierEx<? extends Connection> newConnectionFn;
        private final FunctionEx<? super Session, ? extends MessageConsumer> consumerFn;
        private final FunctionEx<? super Message, ?> messageIdFn;
        private final FunctionEx<? super Message, ? extends T> projectionFn;
        private final EventTimePolicy<? super T> eventTimePolicy;
        private ProcessingGuarantee sourceGuarantee;
        private transient Connection connection;

        public Supplier(SupplierEx<? extends Connection> newConnectionFn, FunctionEx<? super Session, ? extends MessageConsumer> consumerFn, FunctionEx<? super Message, ?> messageIdFn, FunctionEx<? super Message, ? extends T> projectionFn, EventTimePolicy<? super T> eventTimePolicy, ProcessingGuarantee sourceGuarantee) {
            com.hazelcast.jet.impl.util.Util.checkSerializable(newConnectionFn, "newConnectionFn");
            com.hazelcast.jet.impl.util.Util.checkSerializable(consumerFn, "consumerFn");
            com.hazelcast.jet.impl.util.Util.checkSerializable(messageIdFn, "messageIdFn");
            com.hazelcast.jet.impl.util.Util.checkSerializable(projectionFn, "projectionFn");
            this.newConnectionFn = newConnectionFn;
            this.consumerFn = consumerFn;
            this.messageIdFn = messageIdFn;
            this.projectionFn = projectionFn;
            this.eventTimePolicy = eventTimePolicy;
            this.sourceGuarantee = sourceGuarantee;
        }

        @Override
        public void init(@Nonnull ProcessorSupplier.Context context) throws Exception {
            this.connection = (Connection)this.newConnectionFn.get();
            this.connection.start();
            this.sourceGuarantee = com.hazelcast.jet.impl.util.Util.min(this.sourceGuarantee, context.processingGuarantee());
        }

        @Override
        public void close(@Nullable Throwable error) throws Exception {
            if (this.connection != null) {
                this.connection.close();
            }
        }

        @Override
        @Nonnull
        public Collection<? extends Processor> get(int count) {
            return IntStream.range(0, count).mapToObj(i -> new StreamJmsP<T>(this.connection, this.consumerFn, this.messageIdFn, this.projectionFn, this.eventTimePolicy, this.sourceGuarantee)).collect(Collectors.toList());
        }
    }
}

